/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

@Deprecated
public abstract class TimeJDBCDataSink
extends ConvertingJDBCDataSink {
    private final int m_fractionalSecondsPrecision;

    public TimeJDBCDataSink(IWarningListener iWarningListener, TypeMetadata typeMetadata, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
        assert (typeMetadata.getPrecision() >= 0);
        this.m_fractionalSecondsPrecision = typeMetadata.getPrecision();
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fractionalSecondsPrecision;
    }

    protected abstract void doSet(Time var1, Calendar var2) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object != null && !(object instanceof Time)) {
            throw new IncorrectTypeException();
        }
        this.doSet((Time)object, this.getLocalCalendarForConversions());
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 92: 
            case 93: 
            case 2000: {
                this.doSet(null, null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            Time time = NonTrivialJDBCConversions.stringToTime(string, this.m_fractionalSecondsPrecision, this.getAndClearListener(), null);
            if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
                this.onFractionalTruncation(string, this.getFractionalSecondsPrecision(), "setString");
            }
            this.doSet(time, this.getLocalCalendarForConversions());
        }
    }

    @Override
    public void setTime(Time time, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (time == null) {
            this.doSet(null, null);
            return;
        }
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        calendar.setTime(time);
        int n = calendar.get(14);
        int n2 = this.truncateMillis(n);
        if (n2 != n) {
            this.onFractionalTruncation(time, this.getFractionalSecondsPrecision(), "setTime");
            calendar.set(14, n2);
            time.setTime(calendar.getTimeInMillis());
        }
        this.doSet(time, calendar);
    }

    private int truncateMillis(int n) {
        assert (n >= 0);
        switch (this.getFractionalSecondsPrecision()) {
            case 2: {
                return n - n % 10;
            }
            case 1: {
                return n - n % 100;
            }
            case 0: {
                return 0;
            }
        }
        return n;
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (timestamp == null) {
            this.setNull(93);
        } else {
            Time time = NonTrivialJDBCConversions.timestampToTime(timestamp, this.m_fractionalSecondsPrecision, this.getAndClearListener(), calendar);
            if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
                this.onFractionalTruncation(timestamp, this.getFractionalSecondsPrecision(), "setTimestamp");
            }
            this.doSet(time, calendar == null ? this.getLocalCalendarForConversions() : calendar);
        }
    }
}

