/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.telemetry;

import com.databricks.client.hivecommon.AuthMech;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.telemetry.HostDetails;
import java.util.List;

class DriverConnectionParameters {
    public String http_path;
    public String mode = "THRIFT";
    public HostDetails host_info;
    public int auth_mech;
    public String auth_flow;
    public String auth_scope;
    public boolean use_proxy;
    public List<String> non_proxy_hosts;
    public boolean use_system_proxy;
    public boolean use_cf_proxy;
    public HostDetails proxy_host_info;
    public HostDetails cf_proxy_host_info;
    public boolean discovery_mode_enabled;
    public String discovery_url;
    public boolean support_many_parameters;
    public String ssl_trust_store_type;
    public boolean check_certificate_revocation;
    public boolean accept_undetermined_certificate_revocation;

    public DriverConnectionParameters(HiveJDBCSettings hiveJDBCSettings) {
        this.host_info = new HostDetails(hiveJDBCSettings.m_host, hiveJDBCSettings.m_port, null);
        this.http_path = hiveJDBCSettings.m_httpPath;
        this.auth_mech = hiveJDBCSettings.m_authMech.getAuthMechValue();
        this.use_proxy = hiveJDBCSettings.m_proxySettings.m_useProxy;
        if (hiveJDBCSettings.m_authMech == AuthMech.OAUTH_2 && hiveJDBCSettings.m_oAuthSettings != null) {
            this.auth_flow = hiveJDBCSettings.m_oAuthSettings.m_authFlow.toString();
            this.auth_scope = hiveJDBCSettings.m_oAuthSettings.m_authScope;
            this.discovery_mode_enabled = hiveJDBCSettings.m_oAuthSettings.m_EnableOIDCDiscovery;
            this.discovery_url = hiveJDBCSettings.m_oAuthSettings.m_OIDCDiscoveryEndpoint;
        }
        this.non_proxy_hosts = hiveJDBCSettings.m_proxySettings.m_proxyIgnoreList;
        this.use_system_proxy = false;
        this.use_cf_proxy = false;
        if (this.use_proxy) {
            String string = hiveJDBCSettings.m_proxySettings.m_proxyAuth.toString();
            this.proxy_host_info = new HostDetails(hiveJDBCSettings.m_proxySettings.m_proxyHost, hiveJDBCSettings.m_proxySettings.m_proxyPort, string);
        }
        this.ssl_trust_store_type = (hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStore != null || hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore != null) && hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStoreType != null ? hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStoreType : "JKS";
    }
}

