/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.core;

import com.databricks.client.dsi.core.utilities.ConnSettingRequestMap;
import com.databricks.client.dsi.core.utilities.Variant;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.jdbc.common.CustomNetworkHooksSettings;
import com.databricks.client.jdbc.common.OAuthFlow;
import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.common.ProxySettings;
import com.databricks.client.jdbc.common.SSLSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.Warning;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;

public class DSConnectionUtils {
    public static final String O_AUTH_TOKEN_ENDPOINT = "OAuth_";
    public static final String ERROR_ONLY_WINDOWS_SUPPORTED = "OS is unsupported for this feature, only Windows supported.";

    public static void readCustomNetworkHooksProperties(ConnSettingRequestMap connSettingRequestMap, CustomNetworkHooksSettings customNetworkHooksSettings) {
        Variant variant = connSettingRequestMap.getProperty("SocketFactory");
        if (null != variant) {
            customNetworkHooksSettings.m_socketFactory = variant.getString();
            variant = connSettingRequestMap.getProperty("SocketFactoryArg");
            if (null != variant) {
                customNetworkHooksSettings.m_socketFactoryArg = variant.getString();
            }
        }
        if (null != (variant = connSettingRequestMap.getProperty("DnsResolver"))) {
            customNetworkHooksSettings.m_dnsResolver = variant.getString();
            variant = connSettingRequestMap.getProperty("DnsResolverArg");
            if (null != variant) {
                customNetworkHooksSettings.m_dnsResolverArg = variant.getString();
            }
        }
    }

    public static void readOAuthProperties(ConnSettingRequestMap connSettingRequestMap, OAuthSettings oAuthSettings, SSLSettings sSLSettings, IWarningListener iWarningListener) throws ErrorException {
        block9: {
            Variant variant = connSettingRequestMap.getProperty("Auth_Client_ID");
            if (null != variant) {
                oAuthSettings.m_authClientID = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Client_Secret"))) {
                oAuthSettings.m_authClientSecret = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("AuthorizationUrl"))) {
                oAuthSettings.m_authorizationUrl = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Scope"))) {
                oAuthSettings.m_authScope = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_AccessToken"))) {
                oAuthSettings.m_accessToken = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Flow"))) {
                oAuthSettings.m_authFlow = OAuthFlow.convertToOAuthFlow(variant, iWarningListener);
            }
            variant = connSettingRequestMap.getProperty("Auth_Token_Expiry_Buffer");
            oAuthSettings.m_tokenExpiryBuffer = 60;
            if (null != variant) {
                try {
                    oAuthSettings.m_tokenExpiryBuffer = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block9;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{String.valueOf("Auth_Token_Expiry_Buffer"), variant.getString(), "Integers"}));
                }
            }
        }
        DSConnectionUtils.readSSLSettings(connSettingRequestMap, sSLSettings, oAuthSettings.m_tokenEndpointSSLSettings, true, O_AUTH_TOKEN_ENDPOINT, iWarningListener);
    }

    /*
     * Unable to fully structure code
     */
    public static void readSSLSettings(ConnSettingRequestMap var0, SSLSettings var1_1, SSLSettings var2_2, boolean var3_3, String var4_4, IWarningListener var5_5) throws ErrorException {
        block70: {
            var6_6 = var0.getProperty(var4_4 + "UseSystemTrustStore");
            try {
                if (var6_6 != null) {
                    if (var6_6.getInt() == 1) {
                        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
                            var7_7 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "OS is unsupported for this feature, only Windows supported.");
                            throw var7_7;
                        }
                        System.setProperty("javax.net.ssl.trustStoreType", "Windows-ROOT");
                    } else if (var6_6.getInt() != 0) {
                        var7_8 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "UseSystemTrustStore", var6_6.getString(), "0 , 1"});
                        throw var7_8;
                    }
                }
            }
            catch (IncorrectTypeException | NumericOverflowException var7_9) {
                var8_14 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "UseSystemTrustStore", var6_6.getString(), "0 , 1"});
                var8_14.initCause(var7_9);
                throw var8_14;
            }
            var6_6 = var0.getProperty(var4_4 + "ssl");
            if (var3_3) {
                var2_2.m_enableSSL = true;
            } else if (var6_6 != null) {
                try {
                    var7_10 = var6_6.getInt();
                    if (1 == var7_10) {
                        var2_2.m_sslSpecifiedByUser = true;
                        var2_2.m_enableSSL = true;
                    }
                    if (0 == var7_10) {
                        var2_2.m_sslSpecifiedByUser = true;
                        var2_2.m_enableSSL = false;
                    }
                    if (null == var5_5) ** GOTO lbl45
                    var5_5.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "ssl", var6_6.getString(), "0 or 1"}));
                }
                catch (Exception var7_11) {
                    var8_15 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "ssl", var6_6.getString(), "0 , 1"});
                    var8_15.initCause(var7_11);
                    throw var8_15;
                }
            } else if (null != var1_1) {
                var2_2.m_enableSSL = var1_1.m_enableSSL;
            }
lbl45:
            // 8 sources

            var6_6 = var0.getProperty(var4_4 + "SSLKeyStore");
            if (null != var6_6) {
                var2_2.m_sslKeyStore = var6_6.getString();
            } else if (null != var1_1) {
                var2_2.m_sslKeyStore = var1_1.m_sslKeyStore;
            }
            var6_6 = var0.getProperty(var4_4 + "SSLKeyStorePwd");
            if (null != var6_6) {
                var2_2.m_sslKeyStorePwd = var6_6.getString();
            } else if (null != var1_1) {
                var2_2.m_sslKeyStorePwd = var1_1.m_sslKeyStorePwd;
            }
            var6_6 = var0.getProperty(var4_4 + "SSLTrustStore");
            if (null != var6_6) {
                var2_2.m_sslTrustStore = var6_6.getString();
            } else if (null != var1_1) {
                var2_2.m_sslTrustStore = var1_1.m_sslTrustStore;
            }
            var6_6 = var0.getProperty(var4_4 + "SSLTrustStorePwd");
            if (null != var6_6) {
                var2_2.m_sslTrustStorePwd = var6_6.getString();
            } else if (null != var1_1) {
                var2_2.m_sslTrustStorePwd = var1_1.m_sslTrustStorePwd;
            }
            var2_2.m_allowSelfSigned = false;
            var6_6 = var0.getProperty(var4_4 + "AllowSelfSignedCerts");
            if (var6_6 != null) {
                try {
                    if (1 == var6_6.getInt()) {
                        var2_2.m_allowSelfSigned = true;
                        var2_2.m_allowSelfSignedSpecifiedByUser = true;
                    }
                    if (0 == var6_6.getInt()) {
                        var2_2.m_allowSelfSigned = false;
                        var2_2.m_allowSelfSignedSpecifiedByUser = true;
                    }
                    break block70;
                }
                catch (Exception var7_12) {
                    if (null != var5_5) {
                        var5_5.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "AllowSelfSignedCerts", var6_6.getString(), "0 or 1"}));
                    }
                    break block70;
                }
            }
            if (null != var1_1) {
                var2_2.m_allowSelfSigned = var1_1.m_allowSelfSigned;
            }
        }
        var2_2.m_certNamesMismatch = false;
        var7_13 = var0.getProperty(var4_4 + "AllowAllHostNames");
        var8_16 = var0.getProperty(var4_4 + "CAIssuedCertNamesMismatch");
        var9_17 = -1;
        if (null != var8_16) {
            block71: {
                try {
                    var9_17 = var8_16.getInt();
                }
                catch (Exception var10_18) {
                    if (null == var5_5) break block71;
                    var5_5.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "CAIssuedCertNamesMismatch", var6_6.getString(), "0 or 1"}));
                }
            }
            if (1 == var9_17) {
                var2_2.m_certNamesMismatch = true;
                var2_2.m_certNamesMismatchSpecifiedByUser = true;
            } else if (0 == var9_17) {
                var2_2.m_certNamesMismatch = false;
                var2_2.m_certNamesMismatchSpecifiedByUser = true;
            }
        } else if (var7_13 != null) {
            block72: {
                try {
                    var9_17 = var7_13.getInt();
                }
                catch (Exception var10_19) {
                    if (null == var5_5) break block72;
                    var5_5.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "AllowAllHostNames", var6_6.getString(), "0 or 1"}));
                }
            }
            if (1 == var9_17) {
                var2_2.m_certNamesMismatch = true;
                var2_2.m_certNamesMismatchSpecifiedByUser = true;
            } else if (0 == var9_17) {
                var2_2.m_certNamesMismatch = false;
                var2_2.m_certNamesMismatchSpecifiedByUser = true;
            }
        } else if (null != var1_1) {
            var2_2.m_certNamesMismatch = var1_1.m_certNamesMismatch;
        }
        var2_2.m_hostNameInSAN = true;
        var6_6 = var0.getProperty(var4_4 + "SubjectAlternativeNamesHostNames");
        var9_17 = -1;
        if (var6_6 != null) {
            try {
                var9_17 = var6_6.getInt();
            }
            catch (Exception var10_21) {
                var11_22 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{var4_4 + "SubjectAlternativeNamesHostNames", var6_6.getString(), "0 , 1"});
                var11_22.initCause(var10_21);
                throw var11_22;
            }
            if (0 == var9_17) {
                var2_2.m_hostNameInSAN = false;
            } else if (1 == var9_17) {
                var2_2.m_hostNameInSAN = true;
            }
        } else if (null != var1_1) {
            var2_2.m_hostNameInSAN = var1_1.m_hostNameInSAN;
        }
        var6_6 = var0.getProperty(var4_4 + "SSLTrustStoreType");
        if (null != var6_6) {
            var2_2.m_sslTrustStoreType = var6_6.getString();
        } else if (null != var1_1) {
            var2_2.m_sslTrustStoreType = var1_1.m_sslTrustStoreType;
        }
        var6_6 = var0.getProperty(var4_4 + "SSLTrustStoreProvider");
        if (null != var6_6) {
            var2_2.m_sslTrustStoreProvider = var6_6.getString();
        } else if (null != var1_1) {
            var2_2.m_sslTrustStoreProvider = var1_1.m_sslTrustStoreProvider;
        }
        var6_6 = var0.getProperty(var4_4 + "SSLKeyStoreType");
        if (null != var6_6) {
            var2_2.m_sslKeyStoreType = var6_6.getString();
        } else if (null != var1_1) {
            var2_2.m_sslKeyStoreType = var1_1.m_sslKeyStoreType;
        }
        var6_6 = var0.getProperty(var4_4 + "SSLKeyStoreProvider");
        if (null != var6_6) {
            var2_2.m_sslKeyStoreProvider = var6_6.getString();
        } else if (null != var1_1) {
            var2_2.m_sslKeyStoreProvider = var1_1.m_sslKeyStoreProvider;
        }
    }

    public static void readProxySettings(ConnSettingRequestMap connSettingRequestMap, ProxySettings proxySettings) throws ErrorException {
        Variant variant = connSettingRequestMap.getProperty("UseProxy");
        if (null != variant) {
            int n;
            try {
                n = variant.getInt();
                if (1 != n && 0 != n) {
                    throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"UseProxy", variant.getString(), "0/1"});
                }
                proxySettings.m_useProxy = 1 == n;
            }
            catch (Exception exception) {
                throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"UseProxy", variant.getString(), "0/1"});
            }
            if (proxySettings.m_useProxy) {
                variant = connSettingRequestMap.getProperty("ProxyType");
                if (null != variant) {
                    String string = variant.getString();
                    if (string.equals("0") || string.equalsIgnoreCase("HTTP Proxy")) {
                        proxySettings.m_proxyType = ProxySettings.ProxyType.DS_PT_HTTP;
                    } else if (string.equals("1") || string.equalsIgnoreCase("SOCKS Proxy")) {
                        proxySettings.m_proxyType = ProxySettings.ProxyType.DS_PT_SOCKS;
                    } else {
                        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ProxyType", variant.getString(), "0/HTTP Proxy or 1/SOCKS Proxy"});
                    }
                }
                if (null != (variant = connSettingRequestMap.getProperty("DisableProxyForCloudFetch"))) {
                    try {
                        n = variant.getInt();
                        if (1 != n && 0 != n) {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"DisableProxyForCloudFetch", variant.getString(), "0/1"});
                        }
                        proxySettings.m_disableProxyForCloudFetch = 1 == n;
                    }
                    catch (Exception exception) {
                        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"DisableProxyForCloudFetch", variant.getString(), "0/1"});
                    }
                }
                if (null != (variant = connSettingRequestMap.getProperty("InvalidPortProxyCloudFetch"))) {
                    try {
                        n = variant.getInt();
                        if (1 != n && 0 != n) {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"InvalidPortProxyCloudFetch", variant.getString(), "0/1"});
                        }
                        proxySettings.m_InvalidPortProxyCloudFetch = 1 == n;
                    }
                    catch (Exception exception) {
                        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"InvalidPortProxyCloudFetch", variant.getString(), "0/1"});
                    }
                }
                if (proxySettings.m_proxyType.equals((Object)ProxySettings.ProxyType.DS_PT_HTTP)) {
                    variant = connSettingRequestMap.getProperty("ProxyHost");
                    Variant variant2 = connSettingRequestMap.getProperty("ProxyPort");
                    if (null != variant && null != variant2) {
                        proxySettings.m_proxyHost = variant.getString();
                        try {
                            proxySettings.m_proxyPort = variant2.getInt();
                        }
                        catch (Exception exception) {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ProxyPort", variant2.getString(), "Integers"});
                        }
                    } else {
                        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_USE_PROXY_ERR.name());
                    }
                    variant = connSettingRequestMap.getProperty("ProxyAuth");
                    if (null != variant) {
                        String string = variant.getString().toUpperCase();
                        if (string.equals("0") || string.equals("NONE")) {
                            proxySettings.m_proxyAuth = ProxySettings.ProxyAuthentication.NONE;
                        } else if (string.equals("1") || string.equals("BASIC")) {
                            proxySettings.m_proxyAuth = ProxySettings.ProxyAuthentication.BASIC;
                        } else if (string.equals("2") || string.equals("KERBEROS")) {
                            proxySettings.m_proxyAuth = ProxySettings.ProxyAuthentication.KERBEROS;
                        } else {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ProxyAuth", variant.getString(), "0/NONE, 1/BASIC, or 2/KERBEROS"});
                        }
                    }
                    if (proxySettings.m_proxyAuth.equals((Object)ProxySettings.ProxyAuthentication.BASIC)) {
                        variant = connSettingRequestMap.getProperty("ProxyUid");
                        variant2 = connSettingRequestMap.getProperty("ProxyPwd");
                        if (null != variant && null != variant2) {
                            proxySettings.m_proxyUid = variant.getString();
                            proxySettings.m_proxyPwd = variant2.getString();
                        } else {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_PROXY_AUTH_ERR.name());
                        }
                    }
                    if (proxySettings.m_proxyAuth.equals((Object)ProxySettings.ProxyAuthentication.KERBEROS)) {
                        variant = connSettingRequestMap.getProperty("ProxyKrbHostFQDN");
                        proxySettings.m_proxyKrbHostFQDN = null != variant ? variant.getString() : proxySettings.m_proxyHost;
                        variant = connSettingRequestMap.getProperty("ProxyKrbREALM");
                        if (null != variant) {
                            proxySettings.m_proxyKrbRealm = variant.getString();
                        }
                        if (null != (variant = connSettingRequestMap.getProperty("ProxyKrbServiceName"))) {
                            proxySettings.m_proxyKrbServiceName = variant.getString();
                        }
                    }
                    if (null != (variant2 = connSettingRequestMap.getProperty("ProxyIgnoreList")) && !variant2.getString().isEmpty()) {
                        String[] stringArray;
                        proxySettings.m_proxyIgnoreList = new ArrayList<String>();
                        for (String string : stringArray = variant2.getString().split(",")) {
                            string = string.trim();
                            proxySettings.m_proxyIgnoreList.add(string);
                        }
                    }
                }
            }
        }
    }
}

