/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.http.impl.entity;

import com.databricks.client.jdbc42.internal.apache.http.HttpException;
import com.databricks.client.jdbc42.internal.apache.http.HttpMessage;
import com.databricks.client.jdbc42.internal.apache.http.ProtocolException;
import com.databricks.client.jdbc42.internal.apache.http.annotation.Contract;
import com.databricks.client.jdbc42.internal.apache.http.annotation.ThreadingBehavior;
import com.databricks.client.jdbc42.internal.apache.http.entity.ContentLengthStrategy;
import com.databricks.client.jdbc42.internal.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

