/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.arrow;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.dsi.dataengine.utilities.DSITypeUtilities;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.HiveServer2BaseBuffer;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.client.jdbc42.internal.apache.arrow.memory.RootAllocator;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.FieldVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.VarCharVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.VectorLoader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.VectorSchemaRoot;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ipc.ArrowStreamReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ipc.ReadChannel;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ipc.message.MessageSerializer;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.DateUnit;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.FloatingPointPrecision;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.TimeUnit;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.ArrowType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Schema;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TColumnDesc;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowBatch;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeEntry;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeId;
import com.databricks.client.jdbc42.internal.jpountz.lz4.LZ4FrameInputStream;
import com.databricks.client.spark.arrow.ArrowDataRetrievers;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class ArrowBuffer
extends HiveServer2BaseBuffer {
    public ArrowStreamReader m_arrowStreamReader;
    public List<TColumnDesc> m_columnMetadata;
    public byte[] m_resultFile;
    public RootAllocator m_rootAllocator;
    public long m_totalRowsNeeded = 0L;
    private Schema m_arrowSchema;
    private Iterator<TSparkArrowBatch> m_batches;
    private List<FieldVector> m_data;
    private List<List<FieldVector>> m_cachedData;
    private ArrowDataRetrievers m_dataRetriever;
    private int m_processedRows = 0;
    private int m_rowsInCurrBatch = 0;
    private boolean m_isCompressed;
    private BufferAllocator m_bufferAllocator;
    private VectorSchemaRoot m_schemaRoot;
    private static final int NOTHING_TO_READ_FROM_STREAM = -1;
    private static final int VARCHAR_VECTOR_VALUE_INDEX = 0;

    public ArrowBuffer(ILogger iLogger, List<TColumnDesc> list, boolean bl, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        super(iLogger, hiveJDBCSettings);
        this.m_columnMetadata = list;
        this.m_isCompressed = bl;
        this.m_dataRetriever = new ArrowDataRetrievers(iLogger, hiveJDBCSettings.m_useUTF8ForDecoding);
        try {
            this.m_rootAllocator = new RootAllocator();
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage() != null ? throwable.getMessage() : (throwable.getCause() != null ? throwable.getCause().getMessage() : "Error creating Arrow allocator");
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ARROW_INITIALIZATION_ERR.name(), new String[]{string});
        }
    }

    @Override
    public void close() {
        if (null != this.m_schemaRoot) {
            this.m_schemaRoot.close();
            this.m_schemaRoot = null;
        }
        if (null != this.m_bufferAllocator) {
            this.m_bufferAllocator.close();
            this.m_bufferAllocator = null;
        }
        this.closeArrowStreamReader();
        if (null != this.m_rootAllocator) {
            this.m_rootAllocator.close();
            this.m_rootAllocator = null;
        }
    }

    public void convertHS2MetadataToArrowSchema() throws ErrorException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            ArrayList<Field> arrayList = new ArrayList<Field>();
            for (TColumnDesc tColumnDesc : this.m_columnMetadata) {
                arrayList.add(this.getField(tColumnDesc));
            }
            this.m_arrowSchema = new Schema(arrayList);
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ARROW_DESERIALIZATION_ERROR.name(), new String[]{exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, int n2, short s, String string, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, n2, s, hiveJDBCSettings);
        FieldVector fieldVector = this.m_data.get(n);
        int n3 = n2 - this.m_processedRows;
        try {
            switch (s) {
                case -2: {
                    byte[] byArray = this.m_dataRetriever.getBinary(fieldVector, n3);
                    return DSITypeUtilities.outputBinary(byArray, dataWrapper, l, l2);
                }
                case 12: {
                    String string2 = this.m_dataRetriever.getString(fieldVector, n3);
                    if (string2 == null) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    return DSITypeUtilities.outputVarCharStringData(string2, dataWrapper, l, l2);
                }
                case 1: {
                    String string3 = this.m_dataRetriever.getString(fieldVector, n3);
                    if (string3 == null) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    return DSITypeUtilities.outputCharStringData(string3, dataWrapper, l, l2);
                }
                case 16: {
                    this.m_dataRetriever.setBoolean(s, fieldVector, n3, dataWrapper);
                    return false;
                }
                case -6: {
                    this.m_dataRetriever.setTinyInt(s, fieldVector, n3, dataWrapper);
                    return false;
                }
                case 5: {
                    this.m_dataRetriever.setSmallInt(s, fieldVector, n3, dataWrapper);
                    return false;
                }
                case 4: {
                    this.m_dataRetriever.setInteger(s, fieldVector, n3, dataWrapper);
                    return false;
                }
                case -5: {
                    this.m_dataRetriever.setBigInt(s, fieldVector, n3, dataWrapper);
                    return false;
                }
                case 7: {
                    this.m_dataRetriever.setReal(s, fieldVector, n3, dataWrapper);
                    return false;
                }
                case 8: {
                    this.m_dataRetriever.setDouble(s, fieldVector, n3, dataWrapper);
                    return false;
                }
                case 93: {
                    if (hiveJDBCSettings.m_arrowTimestampAsString) {
                        String string4 = this.m_dataRetriever.getString(fieldVector, n3);
                        if (null == string4) {
                            dataWrapper.setNull(s);
                            return false;
                        }
                        dataWrapper.setTimestamp(this.convertTimestamp(string4));
                    } else {
                        this.m_dataRetriever.setTimestamp(s, fieldVector, n3, dataWrapper);
                    }
                    return false;
                }
                case 3: {
                    String string5 = this.m_dataRetriever.getString(fieldVector, n3);
                    if (string5 == null) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    dataWrapper.setDecimal(new BigDecimal(string5));
                    return false;
                }
                case 91: {
                    this.m_dataRetriever.setDate(s, fieldVector, n3, dataWrapper);
                    return false;
                }
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data type is not supported. SqlType: " + Integer.toString(s)});
            throw errorException;
        }
        catch (ErrorException errorException) {
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            ErrorException errorException2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Column" + String.valueOf(n) + ":" + errorException.getMessage()});
            errorException2.initCause(errorException);
            throw errorException2;
        }
    }

    @Override
    public List<Integer> getIntColumn(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), new String[]{"ArrowBuffer's getIntColumn() should not be called"});
        throw errorException;
    }

    @Override
    public int getNumColumns() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_data) {
            return this.m_data.size();
        }
        return 0;
    }

    @Override
    public List<String> getStringColumn(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null == this.m_cachedData) {
            if (!(this.m_data.get(n) instanceof VarCharVector)) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ARROW_INCORRECT_VECTOR_TYPE.name(), new String[]{String.valueOf(n), "VarChar", this.m_data.get(n).getClass().getName()});
                throw errorException;
            }
            this.m_cachedData = new ArrayList<List<FieldVector>>();
            this.m_cachedData.add(this.m_data);
            this.getStringColumnFromBatch(n, this.m_data, arrayList);
            while (this.m_batches.hasNext()) {
                this.deserializeBatch(this.m_batches.next());
                this.m_cachedData.add(this.m_data);
                this.getStringColumnFromBatch(n, this.m_data, arrayList);
            }
        } else {
            this.getStringColFromCachedBatches(n, arrayList);
        }
        return arrayList;
    }

    @Override
    public boolean isGetNextBuffer(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        if (this.m_resultFile != null && (long)n >= this.m_totalRowsNeeded) {
            return true;
        }
        if (this.m_processedRows + this.m_rowsInCurrBatch > n) {
            return false;
        }
        if (this.m_batches != null && this.m_batches.hasNext()) {
            this.m_processedRows += this.m_rowsInCurrBatch;
            this.deserializeBatch(this.m_batches.next());
            return false;
        }
        if (this.m_resultFile != null && this.m_arrowStreamReader != null) {
            try {
                if ((long)(this.m_processedRows + this.m_rowsInCurrBatch) < this.m_totalRowsNeeded && this.m_arrowStreamReader.loadNextBatch()) {
                    this.m_processedRows += this.m_rowsInCurrBatch;
                    this.m_schemaRoot = this.m_arrowStreamReader.getVectorSchemaRoot();
                    this.m_data = this.m_schemaRoot.getFieldVectors();
                    this.m_rowsInCurrBatch = this.m_arrowStreamReader.getVectorSchemaRoot().getRowCount();
                    return false;
                }
                return true;
            }
            catch (IOException iOException) {
                this.close();
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FILE_PARSE_ARROW_ERROR.name(), new String[]{iOException.getMessage()});
                errorException.initCause(iOException);
                throw errorException;
            }
        }
        return true;
    }

    protected ArrowType getArrowType(TTypeId tTypeId) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, tTypeId);
        switch (tTypeId) {
            case NULL_TYPE: {
                return ArrowType.Null.INSTANCE;
            }
            case BOOLEAN_TYPE: {
                return ArrowType.Bool.INSTANCE;
            }
            case TINYINT_TYPE: {
                return new ArrowType.Int(8, true);
            }
            case SMALLINT_TYPE: {
                return new ArrowType.Int(16, true);
            }
            case INT_TYPE: {
                return new ArrowType.Int(32, true);
            }
            case BIGINT_TYPE: {
                return new ArrowType.Int(64, true);
            }
            case FLOAT_TYPE: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
            }
            case DOUBLE_TYPE: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
            }
            case DATE_TYPE: {
                return new ArrowType.Date(DateUnit.DAY);
            }
            case BINARY_TYPE: {
                return ArrowType.Binary.INSTANCE;
            }
            case TIMESTAMP_TYPE: {
                if (this.m_settings.m_arrowTimestampAsString) {
                    return ArrowType.Utf8.INSTANCE;
                }
                return new ArrowType.Timestamp(TimeUnit.MICROSECOND, TimeZone.getDefault().getDisplayName());
            }
            case DECIMAL_TYPE: 
            case VARCHAR_TYPE: 
            case CHAR_TYPE: 
            case STRING_TYPE: 
            case ARRAY_TYPE: 
            case MAP_TYPE: 
            case STRUCT_TYPE: 
            case UNION_TYPE: 
            case USER_DEFINED_TYPE: {
                return ArrowType.Utf8.INSTANCE;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ARROW_DESERIALIZATION_ERROR.name(), new String[]{"Unsupported data type: " + tTypeId.toString()});
        throw errorException;
    }

    public void deserializeBatch(TSparkArrowBatch tSparkArrowBatch) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_arrowSchema) {
            this.convertHS2MetadataToArrowSchema();
        }
        try {
            AutoCloseable autoCloseable;
            if (null == this.m_bufferAllocator && null == this.m_schemaRoot) {
                this.m_bufferAllocator = this.m_rootAllocator.newChildAllocator("fromBatchList", 0L, Long.MAX_VALUE);
                this.m_schemaRoot = VectorSchemaRoot.create(this.m_arrowSchema, this.m_bufferAllocator);
            }
            this.m_rowsInCurrBatch = (int)tSparkArrowBatch.getRowCount();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tSparkArrowBatch.getBatch());
            if (this.m_isCompressed) {
                autoCloseable = new LZ4FrameInputStream(byteArrayInputStream);
                int n = tSparkArrowBatch.getBatch().length * 2;
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (-1 != (n3 = ((LZ4FrameInputStream)autoCloseable).read(byArray, n2, byArray.length - n2))) {
                    if (n <= (n2 += n3)) {
                        byArray = Arrays.copyOf(byArray, n *= 2);
                    }
                    if (-1 != n3) continue;
                }
                ((LZ4FrameInputStream)autoCloseable).close();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
            }
            autoCloseable = MessageSerializer.deserializeRecordBatch(new ReadChannel(Channels.newChannel(byteArrayInputStream)), this.m_bufferAllocator);
            VectorLoader vectorLoader = new VectorLoader(this.m_schemaRoot);
            vectorLoader.load((ArrowRecordBatch)autoCloseable);
            ((ArrowRecordBatch)autoCloseable).close();
            this.m_data = this.m_schemaRoot.getFieldVectors();
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ARROW_DESERIALIZATION_ERROR.name(), new String[]{exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected void getStringColumnFromBatch(int n, List<FieldVector> list, List<String> list2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        VarCharVector varCharVector = (VarCharVector)list.get(n);
        for (int i = 0; i < varCharVector.getValueCount(); ++i) {
            list2.add(this.m_dataRetriever.getString(varCharVector, i));
        }
    }

    @Override
    protected void handleInitializeBuffer() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hiveServer2Buffer != null && this.m_hiveServer2Buffer.getResults().isSetArrowBatches()) {
            this.m_batches = this.m_hiveServer2Buffer.getResults().getArrowBatchesIterator();
            if (this.m_batches.hasNext()) {
                if (this.m_arrowSchema == null) {
                    this.convertHS2MetadataToArrowSchema();
                }
                this.deserializeBatch(this.m_batches.next());
            }
            this.m_processedRows = 0;
            this.m_cachedData = null;
        } else if (null != this.m_resultFile) {
            if (null != this.m_arrowStreamReader) {
                this.closeArrowStreamReader();
            }
            this.m_arrowStreamReader = new ArrowStreamReader(new ByteArrayInputStream(this.m_resultFile), (BufferAllocator)this.m_rootAllocator);
            try {
                if (this.m_arrowStreamReader.loadNextBatch()) {
                    if (null != this.m_schemaRoot) {
                        this.m_schemaRoot.close();
                    }
                    this.m_schemaRoot = this.m_arrowStreamReader.getVectorSchemaRoot();
                    this.m_rowsInCurrBatch = this.m_schemaRoot.getRowCount();
                    if (this.m_totalRowsNeeded > Integer.MAX_VALUE) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FILE_CONTAINS_OVERFLOWN_ROWS.name(), new String[]{String.valueOf(this.m_totalRowsNeeded)});
                        throw errorException;
                    }
                    if (this.m_totalRowsNeeded < (long)this.m_arrowStreamReader.getVectorSchemaRoot().getRowCount()) {
                        this.m_rowsInCurrBatch = (int)this.m_totalRowsNeeded;
                        this.m_arrowStreamReader = null;
                    }
                    this.m_data = this.m_schemaRoot.getFieldVectors();
                }
                this.m_processedRows = 0;
            }
            catch (IOException iOException) {
                this.close();
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FILE_PARSE_ARROW_ERROR.name(), new String[]{iOException.getMessage()});
                errorException.initCause(iOException);
                throw errorException;
            }
        }
    }

    @Override
    protected void setNumRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n = 0;
        if (this.m_hiveServer2Buffer != null && this.m_hiveServer2Buffer.getResults().isSetArrowBatches()) {
            for (TSparkArrowBatch tSparkArrowBatch : this.m_hiveServer2Buffer.getResults().getArrowBatches()) {
                n = (int)((long)n + tSparkArrowBatch.getRowCount());
            }
        } else {
            n = (int)this.m_totalRowsNeeded;
        }
        this.m_numRows = n;
    }

    private void closeArrowStreamReader() {
        if (null != this.m_arrowStreamReader) {
            try {
                this.m_arrowStreamReader.close();
            }
            catch (IOException iOException) {
                LogUtilities.logWarning("An exception happened when closing ArrowStreamReader: " + iOException.getMessage(), this.m_logger);
            }
            this.m_arrowStreamReader = null;
        }
    }

    private void getStringColFromCachedBatches(int n, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        for (List<FieldVector> list2 : this.m_cachedData) {
            this.getStringColumnFromBatch(n, list2, list);
        }
    }

    private Field getField(TColumnDesc tColumnDesc) throws ErrorException {
        TTypeEntry tTypeEntry = tColumnDesc.getTypeDesc().getTypes().get(0);
        TTypeId tTypeId = tTypeEntry.getPrimitiveEntry().getType();
        FieldType fieldType = new FieldType(true, this.getArrowType(tTypeId), null);
        String string = tTypeId.name();
        return new Field(string, fieldType, new ArrayList<Field>());
    }

    public List<String> getUCVolIngestionOpDetails() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_data != null) {
            for (FieldVector fieldVector : this.m_data) {
                VarCharVector varCharVector;
                if (!(fieldVector instanceof VarCharVector) || (varCharVector = (VarCharVector)fieldVector).isNull(0)) continue;
                arrayList.add(new String(varCharVector.get(0)));
            }
        }
        return arrayList;
    }
}

