/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aeoptimizer;

import com.databricks.client.sqlengine.aeprocessor.AEColumnInfo;
import com.databricks.client.sqlengine.aeprocessor.aemanipulator.AETreeManipulator;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AEPassdownFilter;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AEPassdownJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExprScope;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEDummyTable;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESort;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETable;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETop;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEWithClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AETreeCopyUtil;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.databricks.client.sqlengine.dsiext.dataengine.IAggregationHandler;
import com.databricks.client.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.databricks.client.sqlengine.dsiext.dataengine.IDistinctHandler;
import com.databricks.client.sqlengine.dsiext.dataengine.IProjectionHandler;
import com.databricks.client.sqlengine.dsiext.dataengine.ISortHandler;
import com.databricks.client.sqlengine.dsiext.dataengine.ITopHandler;
import com.databricks.client.sqlengine.dsiext.dataengine.IUnionHandler;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.Pair;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;

public final class AERelationalExprHandler {
    private final DSIExtOperationHandlerFactory m_opHandlerFactory;

    public AERelationalExprHandler(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
    }

    public AERelationalExpr passdown(AERelationalExpr aERelationalExpr) {
        return AERelationalExprHandler.suppressedAcceptVisitor(aERelationalExpr, new RelationalExprVisitor(this.m_opHandlerFactory));
    }

    public static AERelationalExpr passdown(AERelationalExpr aERelationalExpr, DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        return AERelationalExprHandler.suppressedAcceptVisitor(aERelationalExpr, new RelationalExprVisitor(dSIExtOperationHandlerFactory));
    }

    public void passdownSubQueries(AEBooleanExpr aEBooleanExpr) {
        this.doPassdownSubQueries(aEBooleanExpr);
    }

    public void passdownSubQueries(AEValueExprList aEValueExprList) {
        this.doPassdownSubQueries(aEValueExprList);
    }

    public void passdownSubQueries(AEValueExpr aEValueExpr) {
        this.doPassdownSubQueries(aEValueExpr);
    }

    public void passdownSubQueries(AESetClauseList aESetClauseList) {
        this.doPassdownSubQueries(aESetClauseList);
    }

    private void doPassdownSubQueries(IAENode iAENode) {
        new RelationalExprVisitor(this.m_opHandlerFactory).passdownSubQueries(iAENode);
    }

    private static <T> T suppressedAcceptVisitor(IAENode iAENode, IAENodeVisitor<T> iAENodeVisitor) {
        try {
            return iAENode.acceptVisitor(iAENodeVisitor);
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
    }

    private static void replaceProxyColumns(final AERelationalExpr aERelationalExpr, final AETable aETable) {
        assert (aETable != null);
        AERelationalExprHandler.suppressedAcceptVisitor(AERelationalExprHandler.findRoot(aERelationalExpr), new AEDefaultVisitor<Void>(){

            @Override
            public Void visit(AEProxyColumn aEProxyColumn) throws ErrorException {
                if (aEProxyColumn.getRelationalExpr() == aERelationalExpr) {
                    AEColumnReference aEColumnReference = new AEColumnReference(new AEColumnInfo(aETable, aEProxyColumn.getColumnNumber(), false));
                    AETreeManipulator.replaceValueExpr(aEProxyColumn, aEColumnReference);
                }
                return null;
            }

            @Override
            protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    IAENode iAENode2 = iterator.next();
                    if (iAENode2 == aERelationalExpr) continue;
                    iAENode2.acceptVisitor(this);
                }
                return null;
            }
        });
    }

    private static IAENode findRoot(IAENode iAENode) {
        IAENode iAENode2 = iAENode;
        while (iAENode2.getParent() != null) {
            iAENode2 = iAENode2.getParent();
        }
        return iAENode2;
    }

    private static class PassdownSubQuery
    extends AEDefaultVisitor<Void> {
        private final DSIExtOperationHandlerFactory m_opHandlerFactory;

        public PassdownSubQuery(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
            this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
        }

        @Override
        public Void visit(AEValueSubQuery aEValueSubQuery) {
            boolean bl = !aEValueSubQuery.isCorrelated();
            AERelationalExpr aERelationalExpr = AERelationalExprHandler.passdown(aEValueSubQuery.getQueryExpression(), bl ? this.m_opHandlerFactory : null);
            if (aERelationalExpr != null) {
                aEValueSubQuery.setQueryExpression(aERelationalExpr);
            }
            return null;
        }

        @Override
        public Void visit(AESubQuery aESubQuery) throws ErrorException {
            boolean bl = !aESubQuery.isCorrelated();
            AERelationalExpr aERelationalExpr = AERelationalExprHandler.passdown(aESubQuery.getOperand(), bl ? this.m_opHandlerFactory : null);
            if (aERelationalExpr != null) {
                if (aERelationalExpr instanceof AETable) {
                    AETreeManipulator.replaceNode(aESubQuery, aERelationalExpr);
                } else {
                    aESubQuery.setOperand(aERelationalExpr);
                }
            }
            return null;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) {
            Iterator<? extends IAENode> iterator = iAENode.getChildItr();
            while (iterator.hasNext()) {
                AERelationalExprHandler.suppressedAcceptVisitor(iterator.next(), this);
            }
            return null;
        }
    }

    private static class RelationalExprVisitor
    extends AEDefaultVisitor<AERelationalExpr> {
        private final DSIExtOperationHandlerFactory m_opHandlerFactory;

        public RelationalExprVisitor(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
            this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
        }

        @Override
        public AERelationalExpr visit(AEProject aEProject) {
            IProjectionHandler iProjectionHandler;
            AERelationalExprHandler.suppressedAcceptVisitor(aEProject.getProjectionList(), new PassdownSubQuery(this.m_opHandlerFactory));
            if (!this.passdownOperand(aEProject)) {
                return aEProject;
            }
            AETable aETable = (AETable)aEProject.getOperand();
            IProjectionHandler iProjectionHandler2 = iProjectionHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createProjectionHandler(aETable.getTable());
            if (iProjectionHandler == null) {
                return aEProject;
            }
            AERelationalExpr aERelationalExpr = iProjectionHandler.passdown(aEProject);
            return aERelationalExpr == null ? aEProject : aERelationalExpr;
        }

        @Override
        public AERelationalExpr visit(AETable aETable) {
            return aETable;
        }

        @Override
        public AERelationalExpr visit(AEDummyTable aEDummyTable) {
            return aEDummyTable;
        }

        @Override
        public AERelationalExpr visit(AESelect aESelect) {
            IBooleanExprHandler iBooleanExprHandler;
            AERelationalExprHandler.suppressedAcceptVisitor(aESelect.getCondition(), new PassdownSubQuery(this.m_opHandlerFactory));
            if (!this.passdownOperand(aESelect)) {
                return aESelect;
            }
            AETable aETable = (AETable)aESelect.getOperand();
            IBooleanExprHandler iBooleanExprHandler2 = iBooleanExprHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createFilterHandler(aETable.getTable());
            if (iBooleanExprHandler == null) {
                return null;
            }
            Pair<DSIExtJResultSet, AEBooleanExpr> pair = new AEPassdownFilter(iBooleanExprHandler).passdown(aESelect.getCondition());
            if (pair.key() != null) {
                aETable.setTable(pair.key());
            }
            if (pair.value() == null) {
                return aETable;
            }
            aESelect.setSelectCond(pair.value());
            return aESelect;
        }

        @Override
        public AERelationalExpr visit(AETop aETop) throws ErrorException {
            DSIExtJResultSet dSIExtJResultSet;
            ITopHandler iTopHandler;
            if (!this.passdownOperand(aETop)) {
                return aETop;
            }
            AETable aETable = (AETable)aETop.getOperand();
            ITopHandler iTopHandler2 = iTopHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createTopHandler(aETable.getTable());
            if (iTopHandler != null && (dSIExtJResultSet = iTopHandler.passdown(aETop)) != null) {
                AETable aETable2 = new AETable(dSIExtJResultSet);
                aETable2.overrideCorrelationSpec(aETable);
                return aETable2;
            }
            return aETop;
        }

        @Override
        public AERelationalExpr visit(AESort aESort) throws ErrorException {
            ISortHandler iSortHandler;
            if (!this.passdownOperand(aESort)) {
                return aESort;
            }
            AETable aETable = (AETable)aESort.getOperand();
            ISortHandler iSortHandler2 = iSortHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createSortHandler(aETable.getTable());
            if (iSortHandler == null) {
                return aESort;
            }
            ISortHandler.ISortPassdownResult iSortPassdownResult = iSortHandler.passdown(aESort);
            if (iSortPassdownResult == null) {
                return aESort;
            }
            assert (iSortPassdownResult.getNumOfPrefixColumns() <= aESort.getSortSpecs().size());
            if (iSortPassdownResult.getNumOfPrefixColumns() == aESort.getSortSpecs().size() && iSortPassdownResult.getSortOrder() == AETable.SESortOrder.ODBC_ORDER) {
                AETable aETable2 = new AETable(iSortPassdownResult.getResultSet(), new AETable.SESortInfo(AETable.SESortOrder.ODBC_ORDER, aESort.getSortSpecs()));
                aETable2.overrideCorrelationSpec(aETable, IntStream.range(0, aETable2.getColumnCount()).toArray());
                return aETable2;
            }
            return aESort;
        }

        @Override
        public AERelationalExpr visit(AECrossJoin aECrossJoin) {
            if (!this.passdownOperand(aECrossJoin) || this.m_opHandlerFactory == null) {
                return aECrossJoin;
            }
            return new AEPassdownJoin(this.m_opHandlerFactory).passdown(aECrossJoin);
        }

        @Override
        public AERelationalExpr visit(AEJoin aEJoin) {
            AERelationalExprHandler.suppressedAcceptVisitor(aEJoin.getJoinCondition(), new PassdownSubQuery(this.m_opHandlerFactory));
            if (!this.passdownOperand(aEJoin) || this.m_opHandlerFactory == null) {
                return aEJoin;
            }
            return new AEPassdownJoin(this.m_opHandlerFactory).passdown(aEJoin);
        }

        @Override
        public AERelationalExpr visit(AEAggregate aEAggregate) throws ErrorException {
            DSIExtJResultSet dSIExtJResultSet;
            IAggregationHandler iAggregationHandler;
            if (!this.passdownOperand(aEAggregate)) {
                return aEAggregate;
            }
            AETable aETable = (AETable)aEAggregate.getOperand();
            IAggregationHandler iAggregationHandler2 = iAggregationHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createAggregationHandler(aETable.getTable());
            if (iAggregationHandler != null && (dSIExtJResultSet = iAggregationHandler.passdown(aEAggregate)) != null) {
                AETable aETable2 = new AETable(dSIExtJResultSet);
                AERelationalExprHandler.replaceProxyColumns(aEAggregate, aETable2);
                aETable2.overrideCorrelationSpec(aETable, RelationalExprVisitor.mapCorrelationSpec(aEAggregate, aETable2));
                return aETable2;
            }
            return aEAggregate;
        }

        @Override
        public AERelationalExpr visit(AEDistinct aEDistinct) throws ErrorException {
            DSIExtJResultSet dSIExtJResultSet;
            IDistinctHandler iDistinctHandler;
            if (!this.passdownOperand(aEDistinct)) {
                return aEDistinct;
            }
            AETable aETable = (AETable)aEDistinct.getOperand();
            IDistinctHandler iDistinctHandler2 = iDistinctHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createDistinctHandler(aETable.getTable());
            if (iDistinctHandler != null && (dSIExtJResultSet = iDistinctHandler.passdown(aEDistinct)) != null) {
                AETable aETable2 = new AETable(dSIExtJResultSet);
                aETable2.overrideCorrelationSpec(aETable);
                return aETable2;
            }
            return aEDistinct;
        }

        @Override
        public AERelationalExpr visit(AESubQuery aESubQuery) {
            boolean bl = aESubQuery.isInFromClause() && !aESubQuery.isCorrelated();
            AERelationalExpr aERelationalExpr = AERelationalExprHandler.passdown(aESubQuery.getOperand(), bl ? this.m_opHandlerFactory : null);
            if (aERelationalExpr != null) {
                if (aERelationalExpr instanceof AETable) {
                    AETable aETable = (AETable)aERelationalExpr;
                    aETable.overrideCorrelationSpec(aESubQuery);
                    this.updateColumns(aESubQuery, aETable);
                    return aETable;
                }
                aESubQuery.setOperand(aERelationalExpr);
            }
            return aESubQuery;
        }

        @Override
        public AERelationalExpr visit(AETableConstructor aETableConstructor) {
            for (int i = 0; i < aETableConstructor.getNumChildren(); ++i) {
                this.passdownSubQueries(aETableConstructor.getRow(i));
            }
            return aETableConstructor;
        }

        @Override
        public AERelationalExpr visit(AEUnion aEUnion) throws ErrorException {
            IUnionHandler iUnionHandler;
            if (!this.passdownOperand(aEUnion)) {
                return aEUnion;
            }
            AETable aETable = (AETable)aEUnion.getLeftOperand();
            AETable aETable2 = (AETable)aEUnion.getRightOperand();
            IUnionHandler iUnionHandler2 = iUnionHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createUnionHandler();
            if (iUnionHandler == null) {
                return aEUnion;
            }
            DSIExtJResultSet dSIExtJResultSet = iUnionHandler.passdown(aETable.getTable(), aETable2.getTable(), aEUnion.getResultSetColumns(), aEUnion.isAllOptPresent());
            if (dSIExtJResultSet != null) {
                AETable aETable3 = new AETable(dSIExtJResultSet);
                aETable3.overrideCorrelationSpec(aETable);
                return aETable3;
            }
            return aEUnion;
        }

        @Override
        public AERelationalExpr visit(AECommonTableExprScope aECommonTableExprScope) throws ErrorException {
            AERelationalExpr aERelationalExpr;
            AEWithClause aEWithClause = aECommonTableExprScope.getLeftOperand();
            if (!aEWithClause.isRecursive()) {
                for (int i = 0; i < aEWithClause.getNumChildren(); ++i) {
                    AENamedRelationalExpr aENamedRelationalExpr;
                    AENamedRelationalExpr aENamedRelationalExpr2 = (AENamedRelationalExpr)aEWithClause.getChild(i);
                    if (aENamedRelationalExpr2 instanceof AETable || (aENamedRelationalExpr = (AENamedRelationalExpr)AERelationalExprHandler.passdown(aENamedRelationalExpr2, this.m_opHandlerFactory)) == null || aENamedRelationalExpr == aENamedRelationalExpr2) continue;
                    aEWithClause.replaceNode(aENamedRelationalExpr, i);
                }
            }
            return (aERelationalExpr = AERelationalExprHandler.passdown(aECommonTableExprScope.getRightOperand(), this.m_opHandlerFactory)) == null ? aECommonTableExprScope.getRightOperand() : aERelationalExpr;
        }

        @Override
        public AERelationalExpr visit(AECommonTableExpr aECommonTableExpr) throws ErrorException {
            AENamedRelationalExpr aENamedRelationalExpr = aECommonTableExpr.GetCommonTableExpression();
            AENamedRelationalExpr aENamedRelationalExpr2 = (AENamedRelationalExpr)AETreeCopyUtil.copySubtree(aENamedRelationalExpr);
            aENamedRelationalExpr2.overrideCorrelationSpec(aECommonTableExpr);
            this.updateColumns(aECommonTableExpr, aENamedRelationalExpr2);
            return aENamedRelationalExpr2;
        }

        @Override
        protected AERelationalExpr defaultVisit(IAENode iAENode) {
            throw SQLEngineExceptionFactory.runtimeException(SQLEngineExceptionFactory.invalidAETreeException());
        }

        private static int[] mapCorrelationSpec(AEAggregate aEAggregate, AETable aETable) {
            final int[] nArray = new int[aETable.getColumnCount()];
            Arrays.fill(nArray, -1);
            AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){
                int m_nextIndex = 0;

                @Override
                public Void visit(AEColumnReference aEColumnReference) {
                    nArray[this.m_nextIndex++] = aEColumnReference.getColumnNum();
                    return null;
                }

                @Override
                protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                    ++this.m_nextIndex;
                    return null;
                }
            };
            for (AEValueExpr aEValueExpr : aEAggregate.getAggregationList()) {
                AERelationalExprHandler.suppressedAcceptVisitor(aEValueExpr, aEDefaultVisitor);
            }
            return nArray;
        }

        private boolean passdownOperand(AEUnaryRelationalExpr aEUnaryRelationalExpr) {
            AERelationalExpr aERelationalExpr = aEUnaryRelationalExpr.getOperand();
            if (aERelationalExpr instanceof AETable) {
                return true;
            }
            AERelationalExpr aERelationalExpr2 = AERelationalExprHandler.passdown(aERelationalExpr, this.m_opHandlerFactory);
            if (aERelationalExpr2 != null) {
                aEUnaryRelationalExpr.getOperand().setParent(null);
                aEUnaryRelationalExpr.setOperand(aERelationalExpr2);
            }
            return aERelationalExpr2 instanceof AETable;
        }

        private boolean passdownOperand(AEBinaryRelationalExpr aEBinaryRelationalExpr) {
            AERelationalExpr aERelationalExpr;
            AERelationalExpr aERelationalExpr2 = aEBinaryRelationalExpr.getLeftOperand();
            AERelationalExpr aERelationalExpr3 = aEBinaryRelationalExpr.getRightOperand();
            if (!(aERelationalExpr2 instanceof AETable) && (aERelationalExpr = AERelationalExprHandler.passdown(aERelationalExpr2, this.m_opHandlerFactory)) != null) {
                aEBinaryRelationalExpr.setLeftOperand(aERelationalExpr);
            }
            if (!(aERelationalExpr3 instanceof AETable) && (aERelationalExpr = AERelationalExprHandler.passdown(aERelationalExpr3, this.m_opHandlerFactory)) != null) {
                aEBinaryRelationalExpr.setRightOperand(aERelationalExpr);
            }
            return aEBinaryRelationalExpr.getLeftOperand() instanceof AETable && aEBinaryRelationalExpr.getRightOperand() instanceof AETable;
        }

        public void passdownSubQueries(IAENode iAENode) {
            try {
                AETreeWalker.walk(iAENode, new AETreeWalker.Action<Void>(){

                    @Override
                    public void act(IAENode iAENode) throws ErrorException {
                        if (RelationalExprVisitor.isSubQuery(iAENode)) {
                            this.skipChildren();
                            iAENode.acceptVisitor(new PassdownSubQuery(m_opHandlerFactory));
                        }
                    }
                });
            }
            catch (ErrorException errorException) {
                throw SQLEngineExceptionFactory.runtimeException(errorException);
            }
        }

        private IAENode getRoot(IAENode iAENode) {
            while (iAENode.getParent() != null && !RelationalExprVisitor.isSubQuery(iAENode)) {
                iAENode = iAENode.getParent();
            }
            return iAENode;
        }

        private static boolean isSubQuery(IAENode iAENode) {
            return iAENode instanceof AESubQuery || iAENode instanceof AEValueSubQuery;
        }

        private void updateColumns(final AENamedRelationalExpr aENamedRelationalExpr, final AENamedRelationalExpr aENamedRelationalExpr2) {
            try {
                AETreeWalker.walk(this.getRoot(aENamedRelationalExpr.getParent()), new AETreeWalker.Action<Void>(){

                    @Override
                    public void act(IAENode iAENode) {
                        AEColumnReference aEColumnReference;
                        if (iAENode == aENamedRelationalExpr) {
                            this.skipChildren();
                        }
                        if (iAENode instanceof AEColumnReference && (aEColumnReference = (AEColumnReference)iAENode).getNamedRelationalExpr() == aENamedRelationalExpr) {
                            aEColumnReference.setNamedRelationalExpr(aENamedRelationalExpr2);
                        }
                    }
                });
            }
            catch (ErrorException errorException) {
                throw SQLEngineExceptionFactory.runtimeException(errorException);
            }
        }
    }
}

