/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor;

import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContext;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ParameterInputValue;
import com.databricks.client.dsi.dataengine.utilities.ParameterType;
import com.databricks.client.dsi.exceptions.DefaultParamException;
import com.databricks.client.dsi.exceptions.ParamAlreadyPushedException;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.ETResultSet;
import com.databricks.client.sqlengine.executor.ETRowCountResult;
import com.databricks.client.sqlengine.executor.IStatementExecutor;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.sqlengine.executor.etree.ETResourceManager;
import com.databricks.client.sqlengine.executor.etree.statement.ETQuery;
import com.databricks.client.sqlengine.executor.etree.statement.IETStatement;
import com.databricks.client.sqlengine.executor.etree.statement.RowCountStatement;
import com.databricks.client.sqlengine.executor.etree.util.RegisterWarningListenerUtil;
import com.databricks.client.sqlengine.executor.etree.value.ETParameter;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Map;

public class StatementExecutor
implements IStatementExecutor {
    private IETStatement m_etStatement;
    private IAEStatement m_aeStatement;
    private ETResourceManager m_rscManager;
    private final ETCancelState m_cancelState;

    public StatementExecutor(IETStatement iETStatement, IAEStatement iAEStatement, ETResourceManager eTResourceManager, ETCancelState eTCancelState) {
        if (!(iETStatement instanceof ETQuery) && !(iETStatement instanceof RowCountStatement)) {
            throw new IllegalArgumentException("Unknown ETree type.");
        }
        this.m_etStatement = iETStatement;
        this.m_aeStatement = iAEStatement;
        this.m_rscManager = eTResourceManager;
        this.m_cancelState = eTCancelState;
    }

    @Override
    public void close() {
        if (this.m_etStatement instanceof RowCountStatement) {
            try {
                ((RowCountStatement)this.m_etStatement).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_etStatement = null;
            if (null != this.m_rscManager) {
                try {
                    this.m_rscManager.free();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_rscManager = null;
            }
        }
    }

    @Override
    public ETCancelState getCancelState() {
        return this.m_cancelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(ExecutionContext executionContext) throws ErrorException {
        ExecutionResult executionResult;
        this.m_cancelState.checkCancel();
        if (this.generatesResultSet()) {
            ETQuery eTQuery = (ETQuery)this.m_etStatement;
            if (executionContext.getInputs().size() != 0) {
                if (eTQuery.getOperand().isOpen()) {
                    throw SQLEngineExceptionFactory.featureNotImplementedException("Multiple active open result sets is not supported.");
                }
                this.pushParameters(executionContext);
            }
            ETResultSet eTResultSet = new ETResultSet(eTQuery, (AEQuery)this.m_aeStatement, this.m_rscManager, this.m_cancelState);
            eTResultSet.setCursorType(CursorType.FORWARD_ONLY);
            executionResult = new ExecutionResult(eTResultSet);
        } else {
            try {
                this.pushParameters(executionContext);
                RowCountStatement rowCountStatement = (RowCountStatement)this.m_etStatement;
                this.m_rscManager.allocate();
                ((RowCountStatement)this.m_etStatement).setGeneratedParameters(executionContext.getGeneratedParameters());
                rowCountStatement.execute();
                ETRowCountResult eTRowCountResult = new ETRowCountResult();
                eTRowCountResult.setRowCount(rowCountStatement.getRowCount());
                executionResult = new ExecutionResult(eTRowCountResult);
                if (executionContext.getGeneratedParameters() != null) {
                    executionResult.setGeneratedResult(rowCountStatement.getGeneratedResult());
                }
            }
            finally {
                this.m_rscManager.free();
            }
        }
        return executionResult;
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        RegisterWarningListenerUtil.registerWarningListener(iWarningListener, this.m_etStatement);
    }

    private void pushParameters(ExecutionContext executionContext) {
        ArrayList<ParameterInputValue> arrayList = executionContext.getInputs();
        for (Map.Entry<Integer, ETParameter> entry : this.m_etStatement.getParameters().entrySet()) {
            assert (entry.getValue().getParamType() == ParameterType.INPUT);
            int n = entry.getKey();
            if (n < 0 || n > arrayList.size()) {
                throw new IllegalStateException("Parameter index in the ETree does not match execution context.");
            }
            ParameterInputValue parameterInputValue = arrayList.get(n - 1);
            try {
                entry.getValue().setInputData(parameterInputValue.getData());
            }
            catch (ParamAlreadyPushedException paramAlreadyPushedException) {
                throw new IllegalStateException("pushed parameter encountered during execution.");
            }
            catch (DefaultParamException defaultParamException) {
                throw new IllegalStateException("Default parameter encountered during execution.");
            }
        }
    }

    @Override
    public void startBatch() throws ErrorException {
        if (this.m_etStatement instanceof RowCountStatement) {
            ((RowCountStatement)this.m_etStatement).startBatch();
        }
    }

    @Override
    public void endBatch() throws ErrorException {
        if (this.m_etStatement instanceof RowCountStatement) {
            ((RowCountStatement)this.m_etStatement).endBatch();
        }
    }

    @Override
    public boolean generatesResultSet() {
        return this.m_etStatement.isResultSet();
    }
}

