/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;

public abstract class AbstractDoubleBinArithFunctor
implements IBinaryArithmeticFunctor {
    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        double d;
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        double d2 = iSqlDataWrapper.getDouble();
        double d3 = this.calculate(d2, d = iSqlDataWrapper2.getDouble());
        if (Double.isNaN(d3)) {
            if (!Double.isNaN(d2) && !Double.isNaN(d)) {
                throw SQLEngineExceptionFactory.notANumberValue();
            }
        } else if (!(Double.isInfinite(d2) || Double.isInfinite(d) || this.checkRange(d3))) {
            throw SQLEngineExceptionFactory.numArithOverflowException();
        }
        eTDataRequest.getData().setDouble(d3);
        return false;
    }

    protected abstract double calculate(double var1, double var3) throws ErrorException;

    private boolean checkRange(double d) {
        return -1.7976931348623157E308 <= d && d <= Double.MAX_VALUE;
    }
}

