/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.support;

import com.databricks.client.support.EscapeTypes;
import com.databricks.client.support.IReplacer;
import com.databricks.client.support.IReplacerChecked;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCEscaper {
    private static final int RETYPE_NAME = 1;
    private static final int RETYPE_VALUE = 2;
    private static final int RETYPE_LIMIT = 3;
    private static final int RETYPE_OFFSET = 4;
    private static final int RETYPE_FNAME = 5;
    private static final int RETYPE_ARGIND = 6;
    private static final int LIKEESCAPE_PATTERN = 2;
    private static final String WS = " \\s*+ ";
    private static final String QWORD = "\\[ [^\\]]*+ \\] ";
    private static final String QNUM = "\\? | \\d++";
    private static final String CCB = "[}]";
    private static final String ARGIND = "[(] |[}]";
    private static final int flags = 14;
    private static final Pattern s_re_scan_squareBracesQuote = JDBCEscaper.createScanPattern(true);
    private static final Pattern s_re_scan_squareBracesDoNotQuote = JDBCEscaper.createScanPattern(false);
    private static final Pattern s_re_type_squareBracesQuote = JDBCEscaper.createTypePattern(true);
    private static final Pattern s_re_type_squareBracesDoNotQuote = JDBCEscaper.createTypePattern(false);
    private static final Pattern s_re_likeEscape = Pattern.compile("(LIKE(\\s)*((?:'[^']*+')+|\\?|(?:(\\s)+\"[^\"]*+\")+))((?:(\\s)+ESCAPE(\\s)*((?:'[^']*+')+|\\?|(?:(\\s)+\"[^\"]*+\")+))|(\\s)*\\{(\\s)*ESCAPE(\\s)*((?:'[^']*+')+|\\?|(?:(\\s)+\"[^\"]*+\")+)(\\s)*\\})", 14);
    private String m_query;
    private Matcher scanMatcher;
    private Matcher typeMatcher;
    private Matcher likeMatcher;
    private boolean treatSquareBracesAsQuotes = true;

    public String Apply(IReplacer iReplacer, String string) {
        return this.Apply((IReplacerChecked)iReplacer, string);
    }

    public <T extends Throwable> String Apply(IReplacerChecked<T> iReplacerChecked, String string) throws T {
        if (string == null || string.isEmpty()) {
            return string;
        }
        assert (iReplacerChecked != null);
        StringBuilder stringBuilder = new StringBuilder();
        this.m_query = string;
        this.scanMatcher = this.getScanPattern().matcher(string);
        this.typeMatcher = this.getTypePattern().matcher(string);
        this.likeMatcher = s_re_likeEscape.matcher(string);
        this.Apply(iReplacerChecked, 0, 0, stringBuilder);
        return stringBuilder.toString();
    }

    public int Scan(String string, int n, String string2) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        this.m_query = string;
        Matcher matcher = this.getScanPattern().matcher(this.m_query);
        n = this.Scan(n, string2, matcher);
        return n;
    }

    public boolean GetTreatSquareBracesAsQuotes() {
        return this.treatSquareBracesAsQuotes;
    }

    public JDBCEscaper SetTreatSquareBracesAsQuotes(boolean bl) {
        this.treatSquareBracesAsQuotes = bl;
        return this;
    }

    private <T extends Throwable> int Apply(IReplacerChecked<T> iReplacerChecked, int n, int n2, StringBuilder stringBuilder) throws T {
        assert (iReplacerChecked != null);
        assert (this.scanMatcher != null);
        assert (this.typeMatcher != null);
        assert (this.m_query != null);
        String string = "?{";
        EscapeTypes escapeTypes = EscapeTypes.UNKNOWN;
        int n3 = 0;
        int n4 = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        while (true) {
            int n5;
            n4 = this.Scan(n, string, this.scanMatcher);
            StringBuilder stringBuilder3 = "?{".equals(string) ? stringBuilder : ("}".equals(string) ? stringBuilder2 : (StringBuilder)arrayList.get(arrayList.size() - 1));
            if (n4 > n) {
                stringBuilder3.append(this.m_query.substring(n, n4));
            }
            if (n4 >= this.m_query.length()) break;
            if (Character.isLetter(this.m_query.charAt(n4))) {
                if (string.equals(",)(}?{")) {
                    assert (n3 > 0);
                    n4 = this.Apply(iReplacerChecked, n4, n2, stringBuilder3);
                } else if ('l' != Character.toLowerCase(this.m_query.charAt(n4))) {
                    assert (n3 == 0);
                    escapeTypes = EscapeTypes.FN;
                    int n6 = n5 = this.m_query.indexOf("(", n4);
                    while (Character.isSpaceChar(this.m_query.charAt(n6 - 1))) {
                        --n6;
                    }
                    arrayList.clear();
                    arrayList.add(new StringBuilder(this.m_query.substring(n4, n6)));
                    n4 = n5 + 1;
                    n3 = 1;
                    string = ",)(}?{";
                } else if (!this.likeMatcher.find(n4)) {
                    stringBuilder.append("LIKE");
                    n4 += 4;
                } else {
                    String string2;
                    escapeTypes = EscapeTypes.LIKE_ESCAPE;
                    n5 = 2;
                    while (null == this.likeMatcher.group(n5)) {
                        ++n5;
                    }
                    stringBuilder.append(this.m_query.substring(n4, this.likeMatcher.start(n5)));
                    stringBuilder.append(" ");
                    arrayList.clear();
                    String string3 = this.likeMatcher.group(n5);
                    int n7 = n5 + 1;
                    while (2 > string3.length()) {
                        int n8 = this.likeMatcher.start(n7);
                        int n9 = this.likeMatcher.end(n7);
                        if (-1 != n8 && -1 != n9) {
                            string3 = this.m_query.substring(this.likeMatcher.start(n7), this.likeMatcher.end(n7++));
                            if (string3.equals("?")) {
                                string3 = iReplacerChecked.replace(EscapeTypes.PARAM, arrayList).toString();
                            }
                            if (n7 != this.likeMatcher.groupCount()) continue;
                            return this.m_query.length();
                        }
                        ++n7;
                    }
                    int n10 = -1;
                    while (-1 == n10) {
                        n10 = this.likeMatcher.start(n7);
                        if (null == this.likeMatcher.group(n7) || 2 > this.likeMatcher.group(n7).length() || this.likeMatcher.group(n7).toUpperCase().contains("ESCAPE")) {
                            n10 = -1;
                        }
                        if (++n7 != this.likeMatcher.groupCount()) continue;
                        return this.m_query.length();
                    }
                    if ((string2 = this.m_query.substring(this.likeMatcher.start(--n7), this.likeMatcher.end(n7))).equals("?")) {
                        string2 = iReplacerChecked.replace(EscapeTypes.PARAM, arrayList).toString();
                    }
                    arrayList.add(new StringBuilder(string3));
                    arrayList.add(new StringBuilder(string2));
                    stringBuilder.append(iReplacerChecked.replace(escapeTypes, arrayList).toString());
                    string = "?{";
                    n4 = this.likeMatcher.end(0);
                }
            } else {
                block0 : switch (this.m_query.charAt(n4++)) {
                    case '?': {
                        stringBuilder3.append((CharSequence)iReplacerChecked.replace(EscapeTypes.PARAM, arrayList));
                        break;
                    }
                    case '(': {
                        ++n3;
                        stringBuilder3.append('(');
                        break;
                    }
                    case ')': {
                        if (--n3 == 0 && ",)(}?{".equals(string)) {
                            string = "}";
                            break;
                        }
                        stringBuilder3.append(')');
                        break;
                    }
                    case ',': {
                        if (n3 == 1) {
                            arrayList.add(new StringBuilder(""));
                            break;
                        }
                        stringBuilder3.append(',');
                        break;
                    }
                    case '}': {
                        assert (!"?{".equals(string));
                        for (n5 = 1; n5 < arrayList.size(); ++n5) {
                            StringBuilder stringBuilder4 = arrayList.get(n5);
                            while (0 != stringBuilder4.length() && Character.isWhitespace(stringBuilder4.charAt(0))) {
                                stringBuilder4.deleteCharAt(0);
                            }
                        }
                        int n11 = stringBuilder.length();
                        if (n11 > 0 && Character.isLetterOrDigit(stringBuilder.charAt(n11 - 1))) {
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append((CharSequence)iReplacerChecked.replace(escapeTypes, arrayList)).append((CharSequence)stringBuilder2);
                        arrayList.clear();
                        stringBuilder2 = new StringBuilder();
                        if (n2 > 0) {
                            return n4;
                        }
                        string = "?{";
                        break;
                    }
                    case '{': {
                        int n11;
                        if (!"?{".equals(string)) {
                            n4 = this.Apply(iReplacerChecked, n4 - 1, n2 + 1, arrayList.get(arrayList.size() - 1));
                            break;
                        }
                        assert (n4 >= 0 && n4 <= this.m_query.length());
                        if (!this.typeMatcher.find(n4) || n4 != this.typeMatcher.start()) {
                            stringBuilder.append(this.m_query.substring(n4 - 1, this.m_query.length()));
                            return this.m_query.length();
                        }
                        n4 = this.typeMatcher.start(1);
                        switch (Character.toLowerCase(this.m_query.charAt(n4))) {
                            case 'd': {
                                escapeTypes = EscapeTypes.DATE;
                                break;
                            }
                            case 'e': {
                                escapeTypes = EscapeTypes.ESCAPE;
                                break;
                            }
                            case 'l': {
                                escapeTypes = EscapeTypes.LIMIT_OFFSET;
                                break;
                            }
                            case 't': {
                                escapeTypes = Character.toLowerCase(this.m_query.charAt(n4 + 1)) == 's' ? EscapeTypes.TIMESTAMP : EscapeTypes.TIME;
                                break;
                            }
                            case 'i': {
                                escapeTypes = EscapeTypes.INTERVAL;
                                break;
                            }
                            case 'o': {
                                escapeTypes = EscapeTypes.OUTERJOIN;
                                break;
                            }
                            case 'c': {
                                escapeTypes = EscapeTypes.CALL;
                                break;
                            }
                            case '?': {
                                escapeTypes = EscapeTypes.RESULT;
                                break;
                            }
                            case 'f': {
                                escapeTypes = EscapeTypes.FN;
                                break;
                            }
                            case 'g': {
                                escapeTypes = EscapeTypes.GUID;
                                break;
                            }
                        }
                        arrayList.clear();
                        switch (escapeTypes) {
                            case DATE: 
                            case ESCAPE: 
                            case TIME: 
                            case TIMESTAMP: 
                            case INTERVAL: 
                            case GUID: {
                                arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(2), this.typeMatcher.end(2))));
                                n11 = stringBuilder.length();
                                if (n11 > 0 && Character.isLetterOrDigit(stringBuilder.charAt(n11 - 1))) {
                                    stringBuilder.append(" ");
                                }
                                stringBuilder.append((CharSequence)iReplacerChecked.replace(escapeTypes, arrayList));
                                if (n2 > 0) {
                                    return this.typeMatcher.end(0);
                                }
                                arrayList.clear();
                                break;
                            }
                            case LIMIT_OFFSET: {
                                arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(3), this.typeMatcher.end(3))));
                                if (this.typeMatcher.start(4) != -1) {
                                    arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(4), this.typeMatcher.end(4))));
                                }
                                stringBuilder.append((CharSequence)iReplacerChecked.replace(escapeTypes, arrayList));
                                break;
                            }
                            case OUTERJOIN: {
                                string = "}?{";
                                arrayList.add(new StringBuilder(""));
                                break;
                            }
                            case CALL: 
                            case RESULT: 
                            case FN: {
                                arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(5), this.typeMatcher.end(5))));
                                n4 = this.typeMatcher.start(6);
                                string = ",)(}?{";
                                if (this.m_query.charAt(n4) == '}') break block0;
                                n3 = 1;
                                arrayList.add(new StringBuilder(""));
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unexpected escape type " + (Object)((Object)escapeTypes));
                            }
                        }
                        n4 = this.typeMatcher.end(0);
                    }
                }
            }
            n = n4;
        }
        return n4;
    }

    private int Scan(int n, String string, Matcher matcher) {
        assert (matcher != null);
        assert (string != null);
        assert (n >= 0 && n <= this.m_query.length());
        while (matcher.find(n)) {
            int n2 = matcher.start(1);
            if (-1 == n2) {
                n2 = matcher.end(0);
            }
            if (n2 == -1 || n2 >= this.m_query.length()) {
                return this.m_query.length();
            }
            char[] cArray = string.toCharArray();
            char c = this.m_query.charAt(n2);
            if (Character.isLetter(c)) {
                return n2;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                return n2;
            }
            n = n2 + 1;
        }
        return this.m_query.length();
    }

    private static Pattern createScanPattern(boolean bl) {
        return Pattern.compile("(?:           \" [^\"]*+ \" |      \\b E   ' (?: \\\\.  |  [^'] )*+ ' | (?<! \\b E ) ' [^']*+   ' " + (bl ? "|  \\[ [^\\]]*+ \\] " : "") + "| -- [^\\n]*+   $| /\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*/| (?! \\b ( CONVERT \\( | LIKE \\b) ) [^$,{?}()] | [^$,{?}()] )*+", 14);
    }

    private Pattern getScanPattern() {
        return this.treatSquareBracesAsQuotes ? s_re_scan_squareBracesQuote : s_re_scan_squareBracesDoNotQuote;
    }

    private Pattern getTypePattern() {
        return this.treatSquareBracesAsQuotes ? s_re_type_squareBracesQuote : s_re_type_squareBracesDoNotQuote;
    }

    private static Pattern createTypePattern(boolean bl) {
        return Pattern.compile(" \\s*+ (  (?:    (?: d | escape | guid | interval | ts | t ) \\s*+     ( (?: - \\s*+ )?      ' [^']* '      [-().,:/\\s\\w]*    )  ) \\s*+ [}]| (?:limit \\s*+ (\\? | \\d++) (?:  \\s*+  offset  \\s*+  (\\? | \\d++) )? ) \\s*+ [}]| oj | (?: call | fn | [?] \\s*+ = \\s*+ call ) \\s*+   ( [\\w.]+   | \" [^\"]* \"  " + (bl ? "  | \\[ [^\\]]*+ \\]  (?:  \\s*+ [.] \\s*+ \\[ [^\\]]*+ \\]  )*" : "") + "  )" + WS + "  ( " + ARGIND + " ))" + WS, 14);
    }
}

