/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.its;

import com.databricks.internal.bouncycastle.its.ITSPublicEncryptionKey;
import com.databricks.internal.bouncycastle.its.ITSValidityPeriod;
import com.databricks.internal.bouncycastle.its.operator.ECDSAEncoder;
import com.databricks.internal.bouncycastle.its.operator.ITSContentVerifierProvider;
import com.databricks.internal.bouncycastle.oer.OEREncoder;
import com.databricks.internal.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import com.databricks.internal.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import com.databricks.internal.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import com.databricks.internal.bouncycastle.oer.its.ieee1609dot2.basetypes.Signature;
import com.databricks.internal.bouncycastle.oer.its.template.ieee1609dot2.IEEE1609dot2;
import com.databricks.internal.bouncycastle.operator.ContentVerifier;
import com.databricks.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.OutputStream;

public class ITSCertificate
implements Encodable {
    private final CertificateBase certificate;

    public ITSCertificate(CertificateBase certificateBase) {
        this.certificate = certificateBase;
    }

    public IssuerIdentifier getIssuer() {
        return this.certificate.getIssuer();
    }

    public ITSValidityPeriod getValidityPeriod() {
        return new ITSValidityPeriod(this.certificate.getToBeSigned().getValidityPeriod());
    }

    public ITSPublicEncryptionKey getPublicEncryptionKey() {
        PublicEncryptionKey publicEncryptionKey = this.certificate.getToBeSigned().getEncryptionKey();
        if (publicEncryptionKey != null) {
            return new ITSPublicEncryptionKey(publicEncryptionKey);
        }
        return null;
    }

    public boolean isSignatureValid(ITSContentVerifierProvider iTSContentVerifierProvider) throws Exception {
        ContentVerifier contentVerifier = iTSContentVerifierProvider.get(this.certificate.getSignature().getChoice());
        OutputStream outputStream = contentVerifier.getOutputStream();
        outputStream.write(OEREncoder.toByteArray(this.certificate.getToBeSigned(), IEEE1609dot2.ToBeSignedCertificate.build()));
        outputStream.close();
        Signature signature = this.certificate.getSignature();
        return contentVerifier.verify(ECDSAEncoder.toX962(signature));
    }

    public CertificateBase toASN1Structure() {
        return this.certificate;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return OEREncoder.toByteArray(this.certificate, IEEE1609dot2.CertificateBase.build());
    }
}

