/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.google.api.client.util;

import com.databricks.internal.google.api.client.util.Base64;
import com.databricks.internal.google.api.client.util.Beta;
import com.databricks.internal.google.api.client.util.PemReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public final class SecurityUtils {
    public static KeyStore getDefaultKeyStore() throws KeyStoreException {
        return KeyStore.getInstance(KeyStore.getDefaultType());
    }

    public static KeyStore getJavaKeyStore() throws KeyStoreException {
        return KeyStore.getInstance("JKS");
    }

    public static KeyStore getPkcs12KeyStore() throws KeyStoreException {
        return KeyStore.getInstance("PKCS12");
    }

    public static void loadKeyStore(KeyStore keyStore, InputStream keyStream, String storePass) throws IOException, GeneralSecurityException {
        try {
            keyStore.load(keyStream, storePass.toCharArray());
        }
        finally {
            keyStream.close();
        }
    }

    public static PrivateKey getPrivateKey(KeyStore keyStore, String alias, String keyPass) throws GeneralSecurityException {
        return (PrivateKey)keyStore.getKey(alias, keyPass.toCharArray());
    }

    public static PrivateKey loadPrivateKeyFromKeyStore(KeyStore keyStore, InputStream keyStream, String storePass, String alias, String keyPass) throws IOException, GeneralSecurityException {
        SecurityUtils.loadKeyStore(keyStore, keyStream, storePass);
        return SecurityUtils.getPrivateKey(keyStore, alias, keyPass);
    }

    public static KeyFactory getRsaKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance("RSA");
    }

    public static Signature getSha1WithRsaSignatureAlgorithm() throws NoSuchAlgorithmException {
        return Signature.getInstance("SHA1withRSA");
    }

    public static Signature getSha256WithRsaSignatureAlgorithm() throws NoSuchAlgorithmException {
        return Signature.getInstance("SHA256withRSA");
    }

    public static Signature getEs256SignatureAlgorithm() throws NoSuchAlgorithmException {
        return Signature.getInstance("SHA256withECDSA");
    }

    public static byte[] sign(Signature signatureAlgorithm, PrivateKey privateKey, byte[] contentBytes) throws InvalidKeyException, SignatureException {
        signatureAlgorithm.initSign(privateKey);
        signatureAlgorithm.update(contentBytes);
        return signatureAlgorithm.sign();
    }

    public static boolean verify(Signature signatureAlgorithm, PublicKey publicKey, byte[] signatureBytes, byte[] contentBytes) throws InvalidKeyException, SignatureException {
        signatureAlgorithm.initVerify(publicKey);
        signatureAlgorithm.update(contentBytes);
        try {
            return signatureAlgorithm.verify(signatureBytes);
        }
        catch (SignatureException e) {
            return false;
        }
    }

    public static X509Certificate verify(Signature signatureAlgorithm, X509TrustManager trustManager, List<String> certChainBase64, byte[] signatureBytes, byte[] contentBytes) throws InvalidKeyException, SignatureException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = SecurityUtils.getX509CertificateFactory();
        }
        catch (CertificateException e) {
            return null;
        }
        X509Certificate[] certificates = new X509Certificate[certChainBase64.size()];
        int currentCert = 0;
        for (String certBase64 : certChainBase64) {
            byte[] certDer = Base64.decodeBase64(certBase64);
            ByteArrayInputStream bis = new ByteArrayInputStream(certDer);
            try {
                Certificate cert = certificateFactory.generateCertificate(bis);
                if (!(cert instanceof X509Certificate)) {
                    return null;
                }
                certificates[currentCert++] = (X509Certificate)cert;
            }
            catch (CertificateException e) {
                return null;
            }
        }
        try {
            trustManager.checkServerTrusted(certificates, "RSA");
        }
        catch (CertificateException e) {
            return null;
        }
        PublicKey pubKey = certificates[0].getPublicKey();
        if (SecurityUtils.verify(signatureAlgorithm, pubKey, signatureBytes, contentBytes)) {
            return certificates[0];
        }
        return null;
    }

    public static CertificateFactory getX509CertificateFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    public static void loadKeyStoreFromCertificates(KeyStore keyStore, CertificateFactory certificateFactory, InputStream certificateStream) throws GeneralSecurityException {
        int i = 0;
        for (Certificate certificate : certificateFactory.generateCertificates(certificateStream)) {
            keyStore.setCertificateEntry(String.valueOf(i), certificate);
            ++i;
        }
    }

    @Beta
    public static KeyStore createMtlsKeyStore(InputStream certAndKey) throws GeneralSecurityException, IOException {
        PemReader.Section section;
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        PemReader.Section certSection = null;
        PemReader.Section keySection = null;
        PemReader reader = new PemReader(new InputStreamReader(certAndKey));
        while ((certSection == null || keySection == null) && (section = reader.readNextSection()) != null) {
            if (certSection == null && "CERTIFICATE".equals(section.getTitle())) {
                certSection = section;
                continue;
            }
            if (!"PRIVATE KEY".equals(section.getTitle())) continue;
            keySection = section;
        }
        if (certSection == null) {
            throw new IllegalArgumentException("certificate is missing from certAndKey string");
        }
        if (keySection == null) {
            throw new IllegalArgumentException("private key is missing from certAndKey string");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certSection.getBase64DecodedBytes()));
        PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(keySection.getBase64DecodedBytes());
        PrivateKey key = KeyFactory.getInstance(cert.getPublicKey().getAlgorithm()).generatePrivate(keySpecPKCS8);
        keystore.setKeyEntry("alias", key, new char[0], new X509Certificate[]{cert});
        return keystore;
    }

    private SecurityUtils() {
    }
}

