/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core;

import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.HeaderFactory;
import java.util.Base64;
import java.util.HashMap;

public class BasicCredentialsProvider
implements CredentialsProvider {
    public static final String BASIC = "basic";

    @Override
    public String authType() {
        return BASIC;
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        String username = config.getUsername();
        String password = config.getPassword();
        String host = config.getHost();
        if (username == null || password == null || host == null) {
            return null;
        }
        byte[] bytes = String.format("%s:%s", config.getUsername(), config.getPassword()).getBytes();
        String base64 = Base64.getEncoder().encodeToString(bytes);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.format("Basic %s", base64));
        return () -> headers;
    }
}

