/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.error.details;

import com.databricks.internal.fasterxml.jackson.core.JsonGenerator;
import com.databricks.internal.fasterxml.jackson.databind.JsonNode;
import com.databricks.internal.fasterxml.jackson.databind.JsonSerializer;
import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.fasterxml.jackson.databind.SerializerProvider;
import com.databricks.internal.fasterxml.jackson.databind.node.ObjectNode;
import com.databricks.internal.sdk.core.error.details.ErrorDetails;
import java.io.IOException;

public class ErrorDetailsSerializer
extends JsonSerializer<ErrorDetails> {
    @Override
    public void serialize(ErrorDetails errorDetails, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartArray();
        if (errorDetails.errorInfo().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.ErrorInfo", errorDetails.errorInfo().get(), serializers);
        }
        if (errorDetails.requestInfo().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.RequestInfo", errorDetails.requestInfo().get(), serializers);
        }
        if (errorDetails.retryInfo().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.RetryInfo", errorDetails.retryInfo().get(), serializers);
        }
        if (errorDetails.debugInfo().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.DebugInfo", errorDetails.debugInfo().get(), serializers);
        }
        if (errorDetails.quotaFailure().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.QuotaFailure", errorDetails.quotaFailure().get(), serializers);
        }
        if (errorDetails.preconditionFailure().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.PreconditionFailure", errorDetails.preconditionFailure().get(), serializers);
        }
        if (errorDetails.badRequest().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.BadRequest", errorDetails.badRequest().get(), serializers);
        }
        if (errorDetails.resourceInfo().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.ResourceInfo", errorDetails.resourceInfo().get(), serializers);
        }
        if (errorDetails.help().isPresent()) {
            this.serializeWithType(gen, "type.googleapis.com/google.rpc.Help", errorDetails.help().get(), serializers);
        }
        for (JsonNode unknownDetail : errorDetails.unknownDetails()) {
            gen.writeObject(unknownDetail);
        }
        gen.writeEndArray();
    }

    private void serializeWithType(JsonGenerator gen, String type, Object obj, SerializerProvider serializers) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object node = mapper.valueToTree(obj);
        if (!(node instanceof ObjectNode)) {
            throw new IllegalArgumentException("Unknown detail type: " + node.getClass().getName());
        }
        ((ObjectNode)node).put("@type", type);
        gen.writeObject(node);
    }
}

