/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.iam.AccountGroupsService;
import com.databricks.internal.sdk.service.iam.DeleteAccountGroupRequest;
import com.databricks.internal.sdk.service.iam.GetAccountGroupRequest;
import com.databricks.internal.sdk.service.iam.Group;
import com.databricks.internal.sdk.service.iam.ListAccountGroupsRequest;
import com.databricks.internal.sdk.service.iam.ListGroupsResponse;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountGroupsImpl
implements AccountGroupsService {
    private final ApiClient apiClient;

    public AccountGroupsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Group create(Group request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Group.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountGroupRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Group get(GetAccountGroupRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Group.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListGroupsResponse list(ListAccountGroupsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListGroupsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(Group request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

