/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.iam.AccountUser;
import com.databricks.internal.sdk.service.iam.AccountUsersV2Service;
import com.databricks.internal.sdk.service.iam.CreateAccountUserRequest;
import com.databricks.internal.sdk.service.iam.DeleteAccountUserRequest;
import com.databricks.internal.sdk.service.iam.GetAccountUserRequest;
import com.databricks.internal.sdk.service.iam.ListAccountUsersRequest;
import com.databricks.internal.sdk.service.iam.ListAccountUsersResponse;
import com.databricks.internal.sdk.service.iam.PatchAccountUserRequest;
import com.databricks.internal.sdk.service.iam.UpdateAccountUserRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountUsersV2Impl
implements AccountUsersV2Service {
    private final ApiClient apiClient;

    public AccountUsersV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountUser create(CreateAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountUser.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountUser get(GetAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountUser.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAccountUsersResponse list(ListAccountUsersRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAccountUsersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PatchAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

