/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.marketplace.AddExchangeForListingRequest;
import com.databricks.internal.sdk.service.marketplace.AddExchangeForListingResponse;
import com.databricks.internal.sdk.service.marketplace.CreateExchangeRequest;
import com.databricks.internal.sdk.service.marketplace.CreateExchangeResponse;
import com.databricks.internal.sdk.service.marketplace.DeleteExchangeRequest;
import com.databricks.internal.sdk.service.marketplace.GetExchangeRequest;
import com.databricks.internal.sdk.service.marketplace.GetExchangeResponse;
import com.databricks.internal.sdk.service.marketplace.ListExchangesForListingRequest;
import com.databricks.internal.sdk.service.marketplace.ListExchangesForListingResponse;
import com.databricks.internal.sdk.service.marketplace.ListExchangesRequest;
import com.databricks.internal.sdk.service.marketplace.ListExchangesResponse;
import com.databricks.internal.sdk.service.marketplace.ListListingsForExchangeRequest;
import com.databricks.internal.sdk.service.marketplace.ListListingsForExchangeResponse;
import com.databricks.internal.sdk.service.marketplace.ProviderExchangesService;
import com.databricks.internal.sdk.service.marketplace.RemoveExchangeForListingRequest;
import com.databricks.internal.sdk.service.marketplace.UpdateExchangeRequest;
import com.databricks.internal.sdk.service.marketplace.UpdateExchangeResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class ProviderExchangesImpl
implements ProviderExchangesService {
    private final ApiClient apiClient;

    public ProviderExchangesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AddExchangeForListingResponse addListingToExchange(AddExchangeForListingRequest request) {
        String path = "/api/2.0/marketplace-exchange/exchanges-for-listing";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AddExchangeForListingResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateExchangeResponse create(CreateExchangeRequest request) {
        String path = "/api/2.0/marketplace-exchange/exchanges";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateExchangeResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteExchangeRequest request) {
        String path = String.format("/api/2.0/marketplace-exchange/exchanges/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteListingFromExchange(RemoveExchangeForListingRequest request) {
        String path = String.format("/api/2.0/marketplace-exchange/exchanges-for-listing/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetExchangeResponse get(GetExchangeRequest request) {
        String path = String.format("/api/2.0/marketplace-exchange/exchanges/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetExchangeResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListExchangesResponse list(ListExchangesRequest request) {
        String path = "/api/2.0/marketplace-exchange/exchanges";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListExchangesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListExchangesForListingResponse listExchangesForListing(ListExchangesForListingRequest request) {
        String path = "/api/2.0/marketplace-exchange/exchanges-for-listing";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListExchangesForListingResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListListingsForExchangeResponse listListingsForExchange(ListListingsForExchangeRequest request) {
        String path = "/api/2.0/marketplace-exchange/listings-for-exchange";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListListingsForExchangeResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateExchangeResponse update(UpdateExchangeRequest request) {
        String path = String.format("/api/2.0/marketplace-exchange/exchanges/%s", request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateExchangeResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

