/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.CreateListingRequest;
import com.databricks.internal.sdk.service.marketplace.CreateListingResponse;
import com.databricks.internal.sdk.service.marketplace.DeleteListingRequest;
import com.databricks.internal.sdk.service.marketplace.GetListingRequest;
import com.databricks.internal.sdk.service.marketplace.GetListingResponse;
import com.databricks.internal.sdk.service.marketplace.GetListingsRequest;
import com.databricks.internal.sdk.service.marketplace.GetListingsResponse;
import com.databricks.internal.sdk.service.marketplace.Listing;
import com.databricks.internal.sdk.service.marketplace.ProviderListingsImpl;
import com.databricks.internal.sdk.service.marketplace.ProviderListingsService;
import com.databricks.internal.sdk.service.marketplace.UpdateListingRequest;
import com.databricks.internal.sdk.service.marketplace.UpdateListingResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProviderListingsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderListingsAPI.class);
    private final ProviderListingsService impl;

    public ProviderListingsAPI(ApiClient apiClient) {
        this.impl = new ProviderListingsImpl(apiClient);
    }

    public ProviderListingsAPI(ProviderListingsService mock) {
        this.impl = mock;
    }

    public CreateListingResponse create(CreateListingRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteListingRequest().setId(id));
    }

    public void delete(DeleteListingRequest request) {
        this.impl.delete(request);
    }

    public GetListingResponse get(String id) {
        return this.get(new GetListingRequest().setId(id));
    }

    public GetListingResponse get(GetListingRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Listing> list(GetListingsRequest request) {
        return new Paginator(request, this.impl::list, GetListingsResponse::getListings, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateListingResponse update(UpdateListingRequest request) {
        return this.impl.update(request);
    }

    public ProviderListingsService impl() {
        return this.impl;
    }
}

