/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class BigDecimalConverter
implements ObjectConverter {
    @Override
    public byte toByte(Object object) throws DatabricksSQLException {
        try {
            return this.toBigDecimal(object).toBigInteger().byteValueExact();
        }
        catch (ArithmeticException e) {
            throw new DatabricksValidationException("Invalid conversion to byte", e);
        }
    }

    @Override
    public short toShort(Object object) throws DatabricksSQLException {
        try {
            return this.toBigDecimal(object).toBigInteger().shortValueExact();
        }
        catch (ArithmeticException e) {
            throw new DatabricksValidationException("Invalid conversion to short", e);
        }
    }

    @Override
    public int toInt(Object object) throws DatabricksSQLException {
        try {
            return this.toBigDecimal(object).toBigInteger().intValueExact();
        }
        catch (ArithmeticException e) {
            throw new DatabricksValidationException("Invalid conversion to int", e);
        }
    }

    @Override
    public long toLong(Object object) throws DatabricksSQLException {
        try {
            return this.toBigDecimal(object).toBigInteger().longValueExact();
        }
        catch (ArithmeticException e) {
            throw new DatabricksValidationException("Invalid conversion to long", e);
        }
    }

    @Override
    public float toFloat(Object object) throws DatabricksSQLException {
        return this.toBigDecimal(object).floatValue();
    }

    @Override
    public double toDouble(Object object) throws DatabricksSQLException {
        return this.toBigDecimal(object).doubleValue();
    }

    @Override
    public BigDecimal toBigDecimal(Object object) throws DatabricksSQLException {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException e) {
                throw new DatabricksValidationException("Invalid BigDecimal string: " + String.valueOf(object), e);
            }
        }
        if (object instanceof Number) {
            return BigDecimal.valueOf(((Number)object).doubleValue());
        }
        throw new DatabricksValidationException("Cannot convert to BigDecimal: " + String.valueOf(object.getClass()));
    }

    @Override
    public BigDecimal toBigDecimal(Object object, int scale) throws DatabricksSQLException {
        BigDecimal bigDecimal = this.toBigDecimal(object);
        try {
            return bigDecimal.setScale(scale, RoundingMode.HALF_EVEN);
        }
        catch (ArithmeticException e) {
            throw new DatabricksValidationException("Error setting scale for BigDecimal", e);
        }
    }

    @Override
    public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        return this.toBigDecimal(object).toBigInteger();
    }

    @Override
    public boolean toBoolean(Object object) throws DatabricksSQLException {
        return !this.toBigDecimal(object).equals(BigDecimal.ZERO);
    }

    @Override
    public byte[] toByteArray(Object object) throws DatabricksSQLException {
        return this.toBigInteger(object).toByteArray();
    }

    @Override
    public String toString(Object object) throws DatabricksSQLException {
        return this.toBigDecimal(object).toString();
    }
}

