/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.apache.arrow.util.VisibleForTesting;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreaker;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.TelemetryRequest;
import com.databricks.jdbc.telemetry.CircuitBreakerManager;
import com.databricks.jdbc.telemetry.ITelemetryPushClient;

public class CircuitBreakerTelemetryPushClient
implements ITelemetryPushClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(CircuitBreakerTelemetryPushClient.class);
    private static final String TEST_CLIENT_NAME = "telemetry-client-test";
    private final ITelemetryPushClient delegate;
    private final CircuitBreaker circuitBreaker;
    private final String host;

    CircuitBreakerTelemetryPushClient(ITelemetryPushClient delegate, String host) {
        this.delegate = delegate;
        this.host = host;
        this.circuitBreaker = CircuitBreakerManager.getInstance().getCircuitBreaker(host);
    }

    @VisibleForTesting
    CircuitBreakerTelemetryPushClient(ITelemetryPushClient delegate, String host, CircuitBreakerConfig config) {
        this.delegate = delegate;
        this.host = host;
        this.circuitBreaker = CircuitBreaker.of(TEST_CLIENT_NAME, config);
    }

    @Override
    public void pushEvent(TelemetryRequest request) {
        block2: {
            try {
                this.circuitBreaker.executeCallable(() -> {
                    this.delegate.pushEvent(request);
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.debug("Failed to export telemetry for host [{}]: {}", this.host, e.getMessage());
                if (this.circuitBreaker.getState() != CircuitBreaker.State.OPEN) break block2;
                LOGGER.debug("CircuitBreaker for host [{}] is OPEN - dropping telemetry", this.host);
            }
        }
    }

    @VisibleForTesting
    CircuitBreaker.State getCircuitBreakerState() {
        return this.circuitBreaker.getState();
    }

    @VisibleForTesting
    CircuitBreaker.Metrics getCircuitBreakerMetrics() {
        return this.circuitBreaker.getMetrics();
    }
}

