/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core;

import com.databricks.internal.sdk.core.CliTokenSource;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.oauth.CachedTokenSource;
import com.databricks.internal.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.internal.sdk.core.utils.OSUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksCliCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DatabricksCliCredentialsProvider.class);
    public static final String DATABRICKS_CLI = "databricks-cli";

    @Override
    public String authType() {
        return DATABRICKS_CLI;
    }

    private CliTokenSource getDatabricksCliTokenSource(DatabricksConfig config) {
        String cliPath = config.getDatabricksCliPath();
        if (cliPath == null) {
            cliPath = OSUtils.get(config.getEnv()).getDatabricksCliPath();
        }
        if (cliPath == null) {
            LOG.debug("Databricks CLI could not be found");
            return null;
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(cliPath, "auth", "token", "--host", config.getHost()));
        if (config.isAccountClient()) {
            cmd.add("--account-id");
            cmd.add(config.getAccountId());
        }
        return new CliTokenSource(cmd, "token_type", "access_token", "expiry", config.getEnv());
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        String host = config.getHost();
        if (host == null) {
            return null;
        }
        try {
            CliTokenSource tokenSource = this.getDatabricksCliTokenSource(config);
            if (tokenSource == null) {
                return null;
            }
            CachedTokenSource cachedTokenSource = new CachedTokenSource.Builder(tokenSource).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
            cachedTokenSource.getToken();
            return OAuthHeaderFactory.fromTokenSource(cachedTokenSource);
        }
        catch (DatabricksException e) {
            String stderr = e.getMessage();
            if (stderr.contains("not found")) {
                LOG.warn("Most likely databricks CLI is not installed");
                return null;
            }
            if (stderr.contains("databricks OAuth is not")) {
                LOG.info("OAuth not configured or not available");
                return null;
            }
            throw e;
        }
    }
}

