/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.http;

import com.databricks.internal.apache.http.client.methods.HttpUriRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class RequestSanitizer {
    private static final List<String> SENSITIVE_QUERY_PARAMS = List.of("X-Amz-Security-Token", "X-Amz-Signature", "X-Amz-Credential");

    public static String sanitizeRequest(HttpUriRequest request) {
        try {
            URI uri = new URI(request.getURI().toString());
            String sanitizedQuery = RequestSanitizer.sanitizeQuery(uri.getRawQuery());
            URI sanitizedUri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), sanitizedQuery, uri.getFragment());
            return sanitizedUri.toString();
        }
        catch (URISyntaxException e) {
            return "Error sanitizing URI: " + e.getMessage();
        }
    }

    private static String sanitizeQuery(String query) {
        String[] pairs;
        if (query == null) {
            return null;
        }
        StringBuilder sanitizedQuery = new StringBuilder();
        for (String pair : pairs = query.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? pair.substring(0, idx) : pair;
            if (SENSITIVE_QUERY_PARAMS.contains(key)) {
                sanitizedQuery.append(key).append("=REDACTED");
            } else {
                sanitizedQuery.append(pair);
            }
            sanitizedQuery.append("&");
        }
        if (sanitizedQuery.length() > 0) {
            sanitizedQuery.setLength(sanitizedQuery.length() - 1);
        }
        return sanitizedQuery.toString();
    }
}

