/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class Collections2 {
    private Collections2() {
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList target = new ArrayList();
        iterator.forEachRemaining(target::add);
        return target;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        return Collections2.toList(iterable.iterator());
    }

    public static <T> List<T> toImmutableList(Iterable<T> iterable) {
        return Collections.unmodifiableList(Collections2.toList(iterable));
    }

    public static <K, V> Map<K, V> immutableMapCopy(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static <V> List<V> immutableListCopy(List<V> list) {
        return Collections.unmodifiableList(new ArrayList<V>(list));
    }

    public static <V> List<V> asImmutableList(V ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static String toString(Iterator<?> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }
}

