/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector.validate;

import com.databricks.internal.apache.arrow.memory.ArrowBuf;
import com.databricks.internal.apache.arrow.vector.BaseFixedWidthVector;
import com.databricks.internal.apache.arrow.vector.BaseLargeVariableWidthVector;
import com.databricks.internal.apache.arrow.vector.BaseVariableWidthVector;
import com.databricks.internal.apache.arrow.vector.BaseVariableWidthViewVector;
import com.databricks.internal.apache.arrow.vector.BitVector;
import com.databricks.internal.apache.arrow.vector.ExtensionTypeVector;
import com.databricks.internal.apache.arrow.vector.FieldVector;
import com.databricks.internal.apache.arrow.vector.NullVector;
import com.databricks.internal.apache.arrow.vector.TypeLayout;
import com.databricks.internal.apache.arrow.vector.ValueVector;
import com.databricks.internal.apache.arrow.vector.compare.VectorVisitor;
import com.databricks.internal.apache.arrow.vector.complex.DenseUnionVector;
import com.databricks.internal.apache.arrow.vector.complex.FixedSizeListVector;
import com.databricks.internal.apache.arrow.vector.complex.LargeListVector;
import com.databricks.internal.apache.arrow.vector.complex.ListVector;
import com.databricks.internal.apache.arrow.vector.complex.NonNullableStructVector;
import com.databricks.internal.apache.arrow.vector.complex.UnionVector;
import com.databricks.internal.apache.arrow.vector.types.pojo.ArrowType;
import com.databricks.internal.apache.arrow.vector.validate.ValidateUtil;

public class ValidateVectorBufferVisitor
implements VectorVisitor<Void, Void> {
    private void validateVectorCommon(ValueVector vector) {
        ArrowType arrowType = vector.getField().getType();
        ValidateUtil.validateOrThrow(vector.getValueCount() >= 0, "Vector valueCount %s is negative.", vector.getValueCapacity());
        if (vector instanceof FieldVector) {
            FieldVector fieldVector = (FieldVector)vector;
            int typeBufferCount = TypeLayout.getTypeBufferCount(arrowType);
            ValidateUtil.validateOrThrow(fieldVector.getFieldBuffers().size() == typeBufferCount, "Expected %s buffers in vector of type %s, got %s.", typeBufferCount, vector.getField().getType().toString(), fieldVector.getFieldBuffers().size());
        }
    }

    private void validateValidityBuffer(ValueVector vector, int valueCount) {
        ArrowBuf validityBuffer = vector.getValidityBuffer();
        ValidateUtil.validateOrThrow(validityBuffer != null, "The validity buffer is null.");
        ValidateUtil.validateOrThrow(validityBuffer.capacity() * 8L >= (long)valueCount, "Not enough capacity for the validity buffer. Minimum capacity %s, actual capacity %s.", (valueCount + 7) / 8, validityBuffer.capacity());
    }

    private void validateOffsetBuffer(ValueVector vector, long minCapacity) {
        ArrowBuf offsetBuffer = vector.getOffsetBuffer();
        ValidateUtil.validateOrThrow(offsetBuffer != null, "The offset buffer is null.");
        ValidateUtil.validateOrThrow(offsetBuffer.capacity() >= minCapacity, "Not enough capacity for the offset buffer. Minimum capacity %s, actual capacity %s.", minCapacity, offsetBuffer.capacity());
    }

    private void validateFixedWidthDataBuffer(ValueVector vector, int valueCount, int bitWidth) {
        ArrowBuf dataBuffer = vector.getDataBuffer();
        ValidateUtil.validateOrThrow(dataBuffer != null, "The fixed width data buffer is null.");
        ValidateUtil.validateOrThrow((long)bitWidth * (long)valueCount <= dataBuffer.capacity() * 8L, "Not enough capacity for fixed width data buffer. Minimum capacity %s, actual capacity %s.", ((long)bitWidth * (long)valueCount + 7L) / 8L, dataBuffer.capacity());
    }

    private void validateDataBuffer(ValueVector vector, long minCapacity) {
        ArrowBuf dataBuffer = vector.getDataBuffer();
        ValidateUtil.validateOrThrow(dataBuffer != null, "The data buffer is null.");
        ValidateUtil.validateOrThrow(dataBuffer.capacity() >= minCapacity, "Not enough capacity for data buffer. Minimum capacity %s, actual capacity %s.", minCapacity, dataBuffer.capacity());
    }

    private void validateTypeBuffer(ArrowBuf typeBuf, long minCapacity) {
        ValidateUtil.validateOrThrow(typeBuf != null, "The type buffer is null.");
        ValidateUtil.validateOrThrow(typeBuf.capacity() >= minCapacity, "Not enough capacity for type buffer. Minimum capacity %s, actual capacity %s.", minCapacity, typeBuf.capacity());
    }

    @Override
    public Void visit(BaseFixedWidthVector vector, Void value) {
        int bitWidth = vector instanceof BitVector ? 1 : vector.getTypeWidth() * 8;
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateValidityBuffer(vector, valueCount);
        this.validateFixedWidthDataBuffer(vector, valueCount, bitWidth);
        return null;
    }

    @Override
    public Void visit(BaseVariableWidthVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateValidityBuffer(vector, valueCount);
        long minOffsetCapacity = valueCount == 0 ? 0L : (long)(valueCount + 1) * 4L;
        this.validateOffsetBuffer(vector, minOffsetCapacity);
        int lastOffset = valueCount == 0 ? 0 : vector.getOffsetBuffer().getInt(valueCount * 4);
        this.validateDataBuffer(vector, lastOffset);
        return null;
    }

    @Override
    public Void visit(BaseLargeVariableWidthVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateValidityBuffer(vector, valueCount);
        long minOffsetCapacity = valueCount == 0 ? 0L : (long)(valueCount + 1) * 8L;
        this.validateOffsetBuffer(vector, minOffsetCapacity);
        long lastOffset = valueCount == 0 ? 0L : vector.getOffsetBuffer().getLong((long)valueCount * 8L);
        this.validateDataBuffer(vector, lastOffset);
        return null;
    }

    @Override
    public Void visit(BaseVariableWidthViewVector vector, Void value) {
        throw new UnsupportedOperationException("View vectors are not supported.");
    }

    @Override
    public Void visit(ListVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateValidityBuffer(vector, valueCount);
        long minOffsetCapacity = valueCount == 0 ? 0L : (long)(valueCount + 1) * 4L;
        this.validateOffsetBuffer(vector, minOffsetCapacity);
        FieldVector dataVector = vector.getDataVector();
        int lastOffset = valueCount == 0 ? 0 : vector.getOffsetBuffer().getInt(valueCount * 4);
        int dataVectorLength = dataVector == null ? 0 : dataVector.getValueCount();
        ValidateUtil.validateOrThrow(dataVectorLength >= lastOffset, "Inner vector does not contain enough elements. Minimum element count %s, actual element count %s", lastOffset + 1, dataVectorLength);
        if (dataVector != null) {
            dataVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(FixedSizeListVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateValidityBuffer(vector, valueCount);
        FieldVector dataVector = vector.getDataVector();
        int dataVectorLength = dataVector == null ? 0 : dataVector.getValueCount();
        ValidateUtil.validateOrThrow(dataVectorLength >= valueCount * vector.getListSize(), "Inner vector does not contain enough elements. Minimum element count %s, actual element count %s.", valueCount * vector.getListSize(), dataVectorLength);
        if (dataVector != null) {
            dataVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(LargeListVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateValidityBuffer(vector, valueCount);
        long minOffsetCapacity = valueCount == 0 ? 0L : (long)(valueCount + 1) * 8L;
        this.validateOffsetBuffer(vector, minOffsetCapacity);
        FieldVector dataVector = vector.getDataVector();
        long lastOffset = valueCount == 0 ? 0L : vector.getOffsetBuffer().getLong(valueCount * 8);
        int dataVectorLength = dataVector == null ? 0 : dataVector.getValueCount();
        ValidateUtil.validateOrThrow((long)dataVectorLength >= lastOffset, "Inner vector does not contain enough elements. Minimum element count %s, actual element count %s", lastOffset + 1L, dataVectorLength);
        if (dataVector != null) {
            dataVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(NonNullableStructVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateValidityBuffer(vector, valueCount);
        for (ValueVector valueVector : vector.getChildrenFromFields()) {
            ValidateUtil.validateOrThrow(valueCount == valueVector.getValueCount(), "Struct vector length not equal to child vector length. Struct vector length %s, child vector length %s", valueCount, valueVector.getValueCount());
            valueVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(UnionVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateTypeBuffer(vector.getTypeBuffer(), valueCount * 1);
        for (ValueVector valueVector : vector.getChildrenFromFields()) {
            ValidateUtil.validateOrThrow(valueCount == valueVector.getValueCount(), "Union vector length not equal to child vector length. Union vector length %s, child vector length %s", valueCount, valueVector.getValueCount());
            valueVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(DenseUnionVector vector, Void value) {
        int valueCount = vector.getValueCount();
        this.validateVectorCommon(vector);
        this.validateOffsetBuffer(vector, (long)valueCount * 4L);
        this.validateTypeBuffer(vector.getTypeBuffer(), valueCount * 1);
        for (ValueVector valueVector : vector.getChildrenFromFields()) {
            valueVector.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visit(NullVector vector, Void value) {
        return null;
    }

    @Override
    public Void visit(ExtensionTypeVector<?> vector, Void value) {
        vector.getUnderlyingVector().accept(this, (Void)value);
        return null;
    }
}

