/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.http.impl.io;

import com.databricks.internal.apache.http.HttpResponse;
import com.databricks.internal.apache.http.annotation.Contract;
import com.databricks.internal.apache.http.annotation.ThreadingBehavior;
import com.databricks.internal.apache.http.impl.io.DefaultHttpResponseWriter;
import com.databricks.internal.apache.http.io.HttpMessageWriter;
import com.databricks.internal.apache.http.io.HttpMessageWriterFactory;
import com.databricks.internal.apache.http.io.SessionOutputBuffer;
import com.databricks.internal.apache.http.message.BasicLineFormatter;
import com.databricks.internal.apache.http.message.LineFormatter;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseWriterFactory
implements HttpMessageWriterFactory<HttpResponse> {
    public static final DefaultHttpResponseWriterFactory INSTANCE = new DefaultHttpResponseWriterFactory();
    private final LineFormatter lineFormatter;

    public DefaultHttpResponseWriterFactory(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpResponseWriterFactory() {
        this(null);
    }

    @Override
    public HttpMessageWriter<HttpResponse> create(SessionOutputBuffer buffer) {
        return new DefaultHttpResponseWriter(buffer, this.lineFormatter);
    }
}

