/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pqc.jcajce.provider.util;

import com.databricks.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.databricks.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.databricks.internal.bouncycastle.crypto.Digest;
import com.databricks.internal.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import com.databricks.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.databricks.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.databricks.internal.bouncycastle.crypto.digests.SHAKEDigest;
import com.databricks.internal.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.databricks.internal.bouncycastle.crypto.params.KDFParameters;
import com.databricks.internal.bouncycastle.jcajce.spec.KEMKDFSpec;
import com.databricks.internal.bouncycastle.util.Arrays;

public class KdfUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] makeKeyBytes(KEMKDFSpec kEMKDFSpec, byte[] byArray) {
        byte[] byArray2;
        block8: {
            byArray2 = null;
            try {
                if (kEMKDFSpec == null) {
                    byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                }
                AlgorithmIdentifier algorithmIdentifier = kEMKDFSpec.getKdfAlgorithm();
                byte[] byArray3 = kEMKDFSpec.getOtherInfo();
                byArray2 = new byte[(kEMKDFSpec.getKeySize() + 7) / 8];
                if (algorithmIdentifier == null) {
                    System.arraycopy(byArray, 0, byArray2, 0, (kEMKDFSpec.getKeySize() + 7) / 8);
                    break block8;
                }
                if (X9ObjectIdentifiers.id_kdf_kdf2.equals(algorithmIdentifier.getAlgorithm())) {
                    AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(algorithmIdentifier.getParameters());
                    KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(KdfUtil.getDigest(algorithmIdentifier2.getAlgorithm()));
                    kDF2BytesGenerator.init(new KDFParameters(byArray, byArray3));
                    kDF2BytesGenerator.generateBytes(byArray2, 0, byArray2.length);
                    break block8;
                }
                if (X9ObjectIdentifiers.id_kdf_kdf3.equals(algorithmIdentifier.getAlgorithm())) {
                    AlgorithmIdentifier algorithmIdentifier3 = AlgorithmIdentifier.getInstance(algorithmIdentifier.getParameters());
                    ConcatenationKDFGenerator concatenationKDFGenerator = new ConcatenationKDFGenerator(KdfUtil.getDigest(algorithmIdentifier3.getAlgorithm()));
                    concatenationKDFGenerator.init(new KDFParameters(byArray, byArray3));
                    concatenationKDFGenerator.generateBytes(byArray2, 0, byArray2.length);
                    break block8;
                }
                if (NISTObjectIdentifiers.id_shake256.equals(algorithmIdentifier.getAlgorithm())) {
                    SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
                    sHAKEDigest.update(byArray, 0, byArray.length);
                    sHAKEDigest.update(byArray3, 0, byArray3.length);
                    sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
                    break block8;
                }
                throw new IllegalStateException("Unrecognized KDF: " + algorithmIdentifier.getAlgorithm());
            }
            finally {
                Arrays.clear(byArray);
            }
        }
        return byArray2;
    }

    static Digest getDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha512)) {
            return new SHA512Digest();
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake128)) {
            return new SHAKEDigest(128);
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake256)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException("unrecognized digest OID: " + aSN1ObjectIdentifier);
    }
}

