/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.algorithm;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.Point;

public class InteriorPointPoint {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public static Coordinate getInteriorPoint(Geometry geom) {
        InteriorPointPoint intPt = new InteriorPointPoint(geom);
        return intPt.getInteriorPoint();
    }

    public InteriorPointPoint(Geometry g2) {
        this.centroid = g2.getCentroid().getCoordinate();
        this.add(g2);
    }

    private void add(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Point) {
            this.add(geom.getCoordinate());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.add(gc.getGeometryN(i));
            }
        }
    }

    private void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }
}

