/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.coverage;

import com.databricks.internal.jts.coverage.CoverageBoundarySegmentFinder;
import com.databricks.internal.jts.coverage.CoverageEdge;
import com.databricks.internal.jts.coverage.VertexRingCounter;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateArrays;
import com.databricks.internal.jts.geom.CoordinateList;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.MultiPolygon;
import com.databricks.internal.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class CoverageRingEdges {
    private Geometry[] coverage;
    private Map<LinearRing, List<CoverageEdge>> ringEdgesMap;
    private List<CoverageEdge> edges;

    public static CoverageRingEdges create(Geometry[] coverage) {
        CoverageRingEdges edges = new CoverageRingEdges(coverage);
        return edges;
    }

    public CoverageRingEdges(Geometry[] coverage) {
        this.coverage = coverage;
        this.ringEdgesMap = new HashMap<LinearRing, List<CoverageEdge>>();
        this.edges = new ArrayList<CoverageEdge>();
        this.build();
    }

    public List<CoverageEdge> getEdges() {
        return this.edges;
    }

    private void build() {
        Set<Coordinate> nodes = this.findMultiRingNodes(this.coverage);
        Set<LineSegment> boundarySegs = CoverageBoundarySegmentFinder.findBoundarySegments(this.coverage);
        nodes.addAll(this.findBoundaryNodes(boundarySegs));
        HashMap<LineSegment, CoverageEdge> uniqueEdgeMap = new HashMap<LineSegment, CoverageEdge>();
        for (int i = 0; i < this.coverage.length; ++i) {
            Geometry geom = this.coverage[i];
            int indexLargest = this.findLargestPolygonIndex(geom);
            for (int ipoly = 0; ipoly < geom.getNumGeometries(); ++ipoly) {
                Polygon poly = (Polygon)geom.getGeometryN(ipoly);
                if (poly.isEmpty()) continue;
                boolean isPrimary = ipoly == indexLargest;
                LinearRing shell = poly.getExteriorRing();
                this.addRingEdges(i, shell, isPrimary, nodes, boundarySegs, uniqueEdgeMap);
                for (int ihole = 0; ihole < poly.getNumInteriorRing(); ++ihole) {
                    LinearRing hole = poly.getInteriorRingN(ihole);
                    if (hole.isEmpty()) continue;
                    this.addRingEdges(i, hole, false, nodes, boundarySegs, uniqueEdgeMap);
                }
            }
        }
    }

    private int findLargestPolygonIndex(Geometry geom) {
        if (geom instanceof Polygon) {
            return 0;
        }
        int indexLargest = -1;
        double areaLargest = -1.0;
        for (int ipoly = 0; ipoly < geom.getNumGeometries(); ++ipoly) {
            Polygon poly = (Polygon)geom.getGeometryN(ipoly);
            double area = poly.getArea();
            if (!(area > areaLargest)) continue;
            areaLargest = area;
            indexLargest = ipoly;
        }
        return indexLargest;
    }

    private void addRingEdges(int index, LinearRing ring, boolean isPrimary, Set<Coordinate> nodes, Set<LineSegment> boundarySegs, HashMap<LineSegment, CoverageEdge> uniqueEdgeMap) {
        this.addBoundaryInnerNodes(ring, boundarySegs, nodes);
        List<CoverageEdge> ringEdges = this.extractRingEdges(index, ring, isPrimary, uniqueEdgeMap, nodes);
        if (ringEdges != null) {
            this.ringEdgesMap.put(ring, ringEdges);
        }
    }

    private void addBoundaryInnerNodes(LinearRing ring, Set<LineSegment> boundarySegs, Set<Coordinate> nodes) {
        boolean isBdyLast;
        CoordinateSequence seq = ring.getCoordinateSequence();
        boolean isBdyPrev = isBdyLast = CoverageBoundarySegmentFinder.isBoundarySegment(boundarySegs, seq, seq.size() - 2);
        for (int i = 0; i < seq.size() - 1; ++i) {
            boolean isBdy = CoverageBoundarySegmentFinder.isBoundarySegment(boundarySegs, seq, i);
            if (isBdy != isBdyPrev) {
                Coordinate nodePt = seq.getCoordinate(i);
                nodes.add(nodePt);
            }
            isBdyPrev = isBdy;
        }
    }

    private List<CoverageEdge> extractRingEdges(int index, LinearRing ring, boolean isPrimary, HashMap<LineSegment, CoverageEdge> uniqueEdgeMap, Set<Coordinate> nodes) {
        ArrayList<CoverageEdge> ringEdges = new ArrayList<CoverageEdge>();
        Coordinate[] pts = ring.getCoordinates();
        if ((pts = CoordinateArrays.removeRepeatedPoints(pts)).length < 3) {
            return null;
        }
        int first = this.findNextNodeIndex(pts, -1, nodes);
        if (first < 0) {
            CoverageEdge edge = this.createEdge(pts, -1, -1, index, isPrimary, uniqueEdgeMap);
            ringEdges.add(edge);
        } else {
            int start;
            int end = start = first;
            boolean isEdgePrimary = true;
            do {
                if ((end = this.findNextNodeIndex(pts, start, nodes)) == start) {
                    isEdgePrimary = isPrimary;
                }
                CoverageEdge edge = this.createEdge(pts, start, end, index, isEdgePrimary, uniqueEdgeMap);
                ringEdges.add(edge);
                start = end;
            } while (end != first);
        }
        return ringEdges;
    }

    private CoverageEdge createEdge(Coordinate[] ring, int start, int end, int index, boolean isPrimary, HashMap<LineSegment, CoverageEdge> uniqueEdgeMap) {
        CoverageEdge edge;
        LineSegment edgeKey;
        LineSegment lineSegment = edgeKey = end == start ? CoverageEdge.key(ring) : CoverageEdge.key(ring, start, end);
        if (uniqueEdgeMap.containsKey(edgeKey)) {
            edge = uniqueEdgeMap.get(edgeKey);
            edge.setPrimary(isPrimary);
        } else {
            edge = start < 0 ? CoverageEdge.createEdge(ring, isPrimary) : CoverageEdge.createEdge(ring, start, end, isPrimary);
            uniqueEdgeMap.put(edgeKey, edge);
            this.edges.add(edge);
        }
        edge.addIndex(index);
        edge.incRingCount();
        return edge;
    }

    private int findNextNodeIndex(Coordinate[] ring, int start, Set<Coordinate> nodes) {
        int index = start;
        boolean isScanned0 = false;
        do {
            Coordinate pt;
            if ((index = CoverageRingEdges.next(index, ring)) == 0) {
                if (start < 0 && isScanned0) {
                    return -1;
                }
                isScanned0 = true;
            }
            if (!nodes.contains(pt = ring[index])) continue;
            return index;
        } while (index != start);
        return -1;
    }

    private static int next(int index, Coordinate[] ring) {
        if (++index >= ring.length - 1) {
            index = 0;
        }
        return index;
    }

    private Set<Coordinate> findMultiRingNodes(Geometry[] coverage) {
        Map<Coordinate, Integer> vertexRingCount = VertexRingCounter.count(coverage);
        HashSet<Coordinate> nodes = new HashSet<Coordinate>();
        for (Coordinate v : vertexRingCount.keySet()) {
            if (vertexRingCount.get(v) < 3) continue;
            nodes.add(v);
        }
        return nodes;
    }

    private Set<Coordinate> findBoundaryNodes(Set<LineSegment> boundarySegments) {
        HashMap<Coordinate, Integer> counter = new HashMap<Coordinate, Integer>();
        for (LineSegment seg : boundarySegments) {
            counter.put(seg.p0, counter.getOrDefault(seg.p0, 0) + 1);
            counter.put(seg.p1, counter.getOrDefault(seg.p1, 0) + 1);
        }
        return counter.entrySet().stream().filter(e -> (Integer)e.getValue() > 2).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Geometry[] buildCoverage() {
        Geometry[] result = new Geometry[this.coverage.length];
        for (int i = 0; i < this.coverage.length; ++i) {
            result[i] = this.buildPolygonal(this.coverage[i]);
        }
        return result;
    }

    private Geometry buildPolygonal(Geometry geom) {
        if (geom instanceof MultiPolygon) {
            return this.buildMultiPolygon((MultiPolygon)geom);
        }
        return this.buildPolygon((Polygon)geom);
    }

    private Geometry buildMultiPolygon(MultiPolygon geom) {
        ArrayList<Polygon> polyList = new ArrayList<Polygon>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon poly = this.buildPolygon((Polygon)geom.getGeometryN(i));
            if (poly == null) continue;
            polyList.add(poly);
        }
        if (polyList.size() == 1) {
            return (Geometry)polyList.get(0);
        }
        Polygon[] polys = GeometryFactory.toPolygonArray(polyList);
        return geom.getFactory().createMultiPolygon(polys);
    }

    private Polygon buildPolygon(Polygon polygon) {
        LinearRing shell = this.buildRing(polygon.getExteriorRing());
        if (shell == null) {
            return null;
        }
        if (polygon.getNumInteriorRing() == 0) {
            return polygon.getFactory().createPolygon(shell);
        }
        ArrayList<LinearRing> holeList = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing hole = polygon.getInteriorRingN(i);
            LinearRing newHole = this.buildRing(hole);
            if (newHole == null) continue;
            holeList.add(newHole);
        }
        LinearRing[] holes = GeometryFactory.toLinearRingArray(holeList);
        return polygon.getFactory().createPolygon(shell, holes);
    }

    private LinearRing buildRing(LinearRing ring) {
        boolean isRemoved;
        List<CoverageEdge> ringEdges = this.ringEdgesMap.get(ring);
        if (ringEdges == null) {
            return (LinearRing)ring.copy();
        }
        boolean bl = isRemoved = ringEdges.size() == 1 && ringEdges.get(0).getCoordinates().length == 0;
        if (isRemoved) {
            return null;
        }
        CoordinateList ptsList = new CoordinateList();
        for (int i = 0; i < ringEdges.size(); ++i) {
            Coordinate lastPt = ptsList.size() > 0 ? ptsList.getCoordinate(ptsList.size() - 1) : null;
            boolean dir = this.isEdgeDirForward(ringEdges, i, lastPt);
            ptsList.add(ringEdges.get(i).getCoordinates(), false, dir);
        }
        Coordinate[] pts = ptsList.toCoordinateArray();
        return ring.getFactory().createLinearRing(pts);
    }

    private boolean isEdgeDirForward(List<CoverageEdge> ringEdges, int index, Coordinate prevPt) {
        int size = ringEdges.size();
        if (size <= 1) {
            return true;
        }
        if (index == 0) {
            if (size == 2) {
                return true;
            }
            Coordinate endPt0 = ringEdges.get(0).getEndCoordinate();
            return endPt0.equals2D(ringEdges.get(1).getStartCoordinate()) || endPt0.equals2D(ringEdges.get(1).getEndCoordinate());
        }
        return prevPt.equals2D(ringEdges.get(index).getStartCoordinate());
    }
}

