/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.coverage;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.CoordinateSequenceFilter;
import com.databricks.internal.jts.geom.CoordinateSequences;
import com.databricks.internal.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Map;

class VertexRingCounter
implements CoordinateSequenceFilter {
    private Map<Coordinate, Integer> vertexRingCount;

    public static Map<Coordinate, Integer> count(Geometry[] geoms) {
        HashMap<Coordinate, Integer> vertexRingCount = new HashMap<Coordinate, Integer>();
        VertexRingCounter counter = new VertexRingCounter(vertexRingCount);
        for (Geometry geom : geoms) {
            geom.apply(counter);
        }
        return vertexRingCount;
    }

    public VertexRingCounter(Map<Coordinate, Integer> vertexRingCount) {
        this.vertexRingCount = vertexRingCount;
    }

    @Override
    public void filter(CoordinateSequence seq, int i) {
        if (CoordinateSequences.isRing(seq) && i == 0) {
            return;
        }
        Coordinate v = seq.getCoordinate(i);
        int count = this.vertexRingCount.containsKey(v) ? this.vertexRingCount.get(v) : 0;
        this.vertexRingCount.put(v, ++count);
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isGeometryChanged() {
        return false;
    }
}

