/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.edgegraph;

import com.databricks.internal.jts.edgegraph.EdgeGraph;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryComponentFilter;
import com.databricks.internal.jts.geom.LineString;
import java.util.Collection;

public class EdgeGraphBuilder {
    private EdgeGraph graph = new EdgeGraph();

    public static EdgeGraph build(Collection geoms) {
        EdgeGraphBuilder builder = new EdgeGraphBuilder();
        builder.add(geoms);
        return builder.getGraph();
    }

    public EdgeGraph getGraph() {
        return this.graph;
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry component) {
                if (component instanceof LineString) {
                    EdgeGraphBuilder.this.add((LineString)component);
                }
            }
        });
    }

    public void add(Collection geometries) {
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    private void add(LineString lineString) {
        CoordinateSequence seq = lineString.getCoordinateSequence();
        for (int i = 1; i < seq.size(); ++i) {
            this.graph.addEdge(seq.getCoordinate(i - 1), seq.getCoordinate(i));
        }
    }
}

