/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.io.kml;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.Point;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.util.StringUtil;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class KMLWriter {
    public static String ALTITUDE_MODE_CLAMPTOGROUND = "clampToGround ";
    public static String ALTITUDE_MODE_RELATIVETOGROUND = "relativeToGround  ";
    public static String ALTITUDE_MODE_ABSOLUTE = "absolute";
    private static final int INDENT_SIZE = 2;
    private static final String COORDINATE_SEPARATOR = ",";
    private static final String TUPLE_SEPARATOR = " ";
    private String linePrefix = null;
    private int maxCoordinatesPerLine = 5;
    private double zVal = Double.NaN;
    private boolean extrude = false;
    private boolean tesselate;
    private String altitudeMode = null;
    private DecimalFormat numberFormatter = null;

    public static String writeGeometry(Geometry geometry, double z) {
        KMLWriter writer = new KMLWriter();
        writer.setZ(z);
        return writer.write(geometry);
    }

    public static String writeGeometry(Geometry geometry, double z, int precision, boolean extrude, String altitudeMode) {
        KMLWriter writer = new KMLWriter();
        writer.setZ(z);
        writer.setPrecision(precision);
        writer.setExtrude(extrude);
        writer.setAltitudeMode(altitudeMode);
        return writer.write(geometry);
    }

    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public void setMaximumCoordinatesPerLine(int maxCoordinatesPerLine) {
        if (maxCoordinatesPerLine <= 0) {
            maxCoordinatesPerLine = 1;
            return;
        }
        this.maxCoordinatesPerLine = maxCoordinatesPerLine;
    }

    public void setZ(double zVal) {
        this.zVal = zVal;
    }

    public void setExtrude(boolean extrude) {
        this.extrude = extrude;
    }

    public void setTesselate(boolean tesselate) {
        this.tesselate = tesselate;
    }

    public void setAltitudeMode(String altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public void setPrecision(int precision) {
        if (precision >= 0) {
            this.numberFormatter = KMLWriter.createFormatter(precision);
        }
    }

    public String write(Geometry geom) {
        StringBuffer buf = new StringBuffer();
        this.write(geom, buf);
        return buf.toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        writer.write(this.write(geometry));
    }

    public void write(Geometry geometry, StringBuffer buf) {
        this.writeGeometry(geometry, 0, buf);
    }

    private void writeGeometry(Geometry g2, int level, StringBuffer buf) {
        String attributes = "";
        if (g2 instanceof Point) {
            this.writePoint((Point)g2, attributes, level, buf);
        } else if (g2 instanceof LinearRing) {
            this.writeLinearRing((LinearRing)g2, attributes, true, level, buf);
        } else if (g2 instanceof LineString) {
            this.writeLineString((LineString)g2, attributes, level, buf);
        } else if (g2 instanceof Polygon) {
            this.writePolygon((Polygon)g2, attributes, level, buf);
        } else if (g2 instanceof GeometryCollection) {
            this.writeGeometryCollection((GeometryCollection)g2, attributes, level, buf);
        } else {
            throw new IllegalArgumentException("Geometry type not supported: " + g2.getGeometryType());
        }
    }

    private void startLine(String text, int level, StringBuffer buf) {
        if (this.linePrefix != null) {
            buf.append(this.linePrefix);
        }
        buf.append(StringUtil.spaces(2 * level));
        buf.append(text);
    }

    private String geometryTag(String geometryName, String attributes) {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(geometryName);
        if (attributes != null && attributes.length() > 0) {
            buf.append(TUPLE_SEPARATOR);
            buf.append(attributes);
        }
        buf.append(">");
        return buf.toString();
    }

    private void writeModifiers(int level, StringBuffer buf) {
        if (this.extrude) {
            this.startLine("<extrude>1</extrude>\n", level, buf);
        }
        if (this.tesselate) {
            this.startLine("<tesselate>1</tesselate>\n", level, buf);
        }
        if (this.altitudeMode != null) {
            this.startLine("<altitudeMode>" + this.altitudeMode + "</altitudeMode>\n", level, buf);
        }
    }

    private void writePoint(Point p, String attributes, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("Point", attributes) + "\n", level, buf);
        this.writeModifiers(level, buf);
        this.write(new Coordinate[]{p.getCoordinate()}, level + 1, buf);
        this.startLine("</Point>\n", level, buf);
    }

    private void writeLineString(LineString ls, String attributes, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("LineString", attributes) + "\n", level, buf);
        this.writeModifiers(level, buf);
        this.write(ls.getCoordinates(), level + 1, buf);
        this.startLine("</LineString>\n", level, buf);
    }

    private void writeLinearRing(LinearRing lr, String attributes, boolean writeModifiers, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("LinearRing", attributes) + "\n", level, buf);
        if (writeModifiers) {
            this.writeModifiers(level, buf);
        }
        this.write(lr.getCoordinates(), level + 1, buf);
        this.startLine("</LinearRing>\n", level, buf);
    }

    private void writePolygon(Polygon p, String attributes, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("Polygon", attributes) + "\n", level, buf);
        this.writeModifiers(level, buf);
        this.startLine("  <outerBoundaryIs>\n", level, buf);
        this.writeLinearRing(p.getExteriorRing(), null, false, level + 1, buf);
        this.startLine("  </outerBoundaryIs>\n", level, buf);
        for (int t2 = 0; t2 < p.getNumInteriorRing(); ++t2) {
            this.startLine("  <innerBoundaryIs>\n", level, buf);
            this.writeLinearRing(p.getInteriorRingN(t2), null, false, level + 1, buf);
            this.startLine("  </innerBoundaryIs>\n", level, buf);
        }
        this.startLine("</Polygon>\n", level, buf);
    }

    private void writeGeometryCollection(GeometryCollection gc, String attributes, int level, StringBuffer buf) {
        this.startLine("<MultiGeometry>\n", level, buf);
        for (int t2 = 0; t2 < gc.getNumGeometries(); ++t2) {
            this.writeGeometry(gc.getGeometryN(t2), level + 1, buf);
        }
        this.startLine("</MultiGeometry>\n", level, buf);
    }

    private void write(Coordinate[] coords, int level, StringBuffer buf) {
        this.startLine("<coordinates>", level, buf);
        boolean isNewLine = false;
        for (int i = 0; i < coords.length; ++i) {
            if (i > 0) {
                buf.append(TUPLE_SEPARATOR);
            }
            if (isNewLine) {
                this.startLine("  ", level, buf);
                isNewLine = false;
            }
            this.write(coords[i], buf);
            if ((i + 1) % this.maxCoordinatesPerLine != 0 || i >= coords.length - 1) continue;
            buf.append("\n");
            isNewLine = true;
        }
        buf.append("</coordinates>\n");
    }

    private void write(Coordinate p, StringBuffer buf) {
        this.write(p.x, buf);
        buf.append(COORDINATE_SEPARATOR);
        this.write(p.y, buf);
        double z = p.getZ();
        if (!Double.isNaN(this.zVal)) {
            z = this.zVal;
        }
        if (!Double.isNaN(z)) {
            buf.append(COORDINATE_SEPARATOR);
            this.write(z, buf);
        }
    }

    private void write(double num, StringBuffer buf) {
        if (this.numberFormatter != null) {
            buf.append(this.numberFormatter.format(num));
        } else {
            buf.append(num);
        }
    }

    private static DecimalFormat createFormatter(int precision) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("0." + StringUtil.chars('#', precision), symbols);
        format.setDecimalSeparatorAlwaysShown(false);
        return format;
    }
}

