/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.overlay.snap;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.util.GeometryTransformer;
import com.databricks.internal.jts.operation.overlay.snap.LineStringSnapper;

class SnapTransformer
extends GeometryTransformer {
    private double snapTolerance;
    private Coordinate[] snapPts;
    private boolean isSelfSnap = false;

    SnapTransformer(double snapTolerance, Coordinate[] snapPts) {
        this.snapTolerance = snapTolerance;
        this.snapPts = snapPts;
    }

    SnapTransformer(double snapTolerance, Coordinate[] snapPts, boolean isSelfSnap) {
        this.snapTolerance = snapTolerance;
        this.snapPts = snapPts;
        this.isSelfSnap = isSelfSnap;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
        Coordinate[] srcPts = coords.toCoordinateArray();
        Coordinate[] newPts = this.snapLine(srcPts, this.snapPts);
        return this.factory.getCoordinateSequenceFactory().create(newPts);
    }

    private Coordinate[] snapLine(Coordinate[] srcPts, Coordinate[] snapPts) {
        LineStringSnapper snapper = new LineStringSnapper(srcPts, this.snapTolerance);
        snapper.setAllowSnappingToSourceVertices(this.isSelfSnap);
        return snapper.snapTo(snapPts);
    }
}

