/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.simplify;

import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.index.quadtree.Quadtree;
import com.databricks.internal.jts.simplify.LineSegmentVisitor;
import com.databricks.internal.jts.simplify.TaggedLineSegment;
import com.databricks.internal.jts.simplify.TaggedLineString;
import java.util.ArrayList;
import java.util.List;

class LineSegmentIndex {
    private Quadtree index = new Quadtree();

    public void add(TaggedLineString line) {
        TaggedLineSegment[] segs = line.getSegments();
        for (int i = 0; i < segs.length; ++i) {
            TaggedLineSegment seg = segs[i];
            this.add(seg);
        }
    }

    public void add(LineSegment seg) {
        this.index.insert(new Envelope(seg.p0, seg.p1), seg);
    }

    public void remove(LineSegment seg) {
        this.index.remove(new Envelope(seg.p0, seg.p1), seg);
    }

    public List<Object> query(LineSegment querySeg) {
        Envelope env = new Envelope(querySeg.p0, querySeg.p1);
        LineSegmentVisitor visitor = new LineSegmentVisitor(querySeg);
        this.index.query(env, visitor);
        ArrayList<Object> itemsFound = visitor.getItems();
        return itemsFound;
    }
}

