/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.simplify;

import com.databricks.internal.jts.simplify.ComponentJumpChecker;
import com.databricks.internal.jts.simplify.LineSegmentIndex;
import com.databricks.internal.jts.simplify.TaggedLineString;
import com.databricks.internal.jts.simplify.TaggedLineStringSimplifier;
import java.util.Collection;
import java.util.Iterator;

class TaggedLinesSimplifier {
    private LineSegmentIndex inputIndex = new LineSegmentIndex();
    private LineSegmentIndex outputIndex = new LineSegmentIndex();
    private double distanceTolerance = 0.0;

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public void simplify(Collection taggedLines) {
        ComponentJumpChecker jumpChecker = new ComponentJumpChecker(taggedLines);
        Iterator i = taggedLines.iterator();
        while (i.hasNext()) {
            this.inputIndex.add((TaggedLineString)i.next());
        }
        i = taggedLines.iterator();
        while (i.hasNext()) {
            TaggedLineStringSimplifier tlss = new TaggedLineStringSimplifier(this.inputIndex, this.outputIndex, jumpChecker);
            tlss.simplify((TaggedLineString)i.next(), this.distanceTolerance);
        }
    }
}

