/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.triangulate;

import com.databricks.internal.jts.algorithm.Orientation;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.triangulate.quadedge.QuadEdge;
import com.databricks.internal.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.databricks.internal.jts.triangulate.quadedge.Vertex;
import java.util.Collection;

public class IncrementalDelaunayTriangulator {
    private QuadEdgeSubdivision subdiv;
    private boolean isUsingTolerance = false;
    private boolean isForceConvex = true;

    public IncrementalDelaunayTriangulator(QuadEdgeSubdivision subdiv) {
        this.subdiv = subdiv;
        this.isUsingTolerance = subdiv.getTolerance() > 0.0;
    }

    public void forceConvex(boolean isForceConvex) {
        this.isForceConvex = isForceConvex;
    }

    public void insertSites(Collection vertices) {
        for (Vertex v : vertices) {
            this.insertSite(v);
        }
    }

    public QuadEdge insertSite(Vertex v) {
        QuadEdge e = this.subdiv.locate(v);
        if (this.subdiv.isVertexOfEdge(e, v)) {
            return e;
        }
        if (this.subdiv.isOnEdge(e, v.getCoordinate())) {
            e = e.oPrev();
            this.subdiv.delete(e.oNext());
        }
        QuadEdge base = this.subdiv.makeEdge(e.orig(), v);
        QuadEdge.splice(base, e);
        QuadEdge startEdge = base;
        while ((e = (base = this.subdiv.connect(e, base.sym())).oPrev()).lNext() != startEdge) {
        }
        while (true) {
            QuadEdge t2;
            boolean doFlip;
            boolean bl = doFlip = (t2 = e.oPrev()).dest().rightOf(e) && v.isInCircle(e.orig(), t2.dest(), e.dest());
            if (this.isForceConvex) {
                if (this.isConcaveBoundary(e)) {
                    doFlip = true;
                } else if (this.isBetweenFrameAndInserted(e, v)) {
                    doFlip = false;
                }
            }
            if (doFlip) {
                QuadEdge.swap(e);
                e = e.oPrev();
                continue;
            }
            if (e.oNext() == startEdge) {
                return base;
            }
            e = e.oNext().lPrev();
        }
    }

    private boolean isConcaveBoundary(QuadEdge e) {
        if (this.subdiv.isFrameVertex(e.dest())) {
            return IncrementalDelaunayTriangulator.isConcaveAtOrigin(e);
        }
        if (this.subdiv.isFrameVertex(e.orig())) {
            return IncrementalDelaunayTriangulator.isConcaveAtOrigin(e.sym());
        }
        return false;
    }

    private static boolean isConcaveAtOrigin(QuadEdge e) {
        Coordinate pn;
        Coordinate p = e.orig().getCoordinate();
        Coordinate pp = e.oPrev().dest().getCoordinate();
        boolean isConcave = 1 == Orientation.index(pp, pn = e.oNext().dest().getCoordinate(), p);
        return isConcave;
    }

    private boolean isBetweenFrameAndInserted(QuadEdge e, Vertex vInsert) {
        Vertex v1 = e.oNext().dest();
        Vertex v2 = e.oPrev().dest();
        return v1 == vInsert && this.subdiv.isFrameVertex(v2) || v2 == vInsert && this.subdiv.isFrameVertex(v1);
    }
}

