/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.utils;

import com.databricks.internal.apache.http.HttpHost;
import com.databricks.internal.apache.http.auth.AuthScope;
import com.databricks.internal.apache.http.auth.Credentials;
import com.databricks.internal.apache.http.auth.UsernamePasswordCredentials;
import com.databricks.internal.apache.http.config.RegistryBuilder;
import com.databricks.internal.apache.http.impl.auth.SPNegoSchemeFactory;
import com.databricks.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.databricks.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.internal.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.ProxyConfig;
import com.databricks.internal.sdk.core.utils.CustomRoutePlanner;
import java.security.Principal;

public class ProxyUtils {
    public static void setupProxy(ProxyConfig config, HttpClientBuilder builder) {
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUser = null;
        String proxyPassword = null;
        ProxyConfig.ProxyAuthType proxyAuthType = null;
        if (config.getUseSystemProperties() != null && config.getUseSystemProperties().booleanValue()) {
            builder.useSystemProperties();
            String protocol = System.getProperty("https.proxyHost") != null ? "https" : "http";
            proxyHost = System.getProperty(protocol + ".proxyHost");
            proxyPort = Integer.parseInt(System.getProperty(protocol + ".proxyPort"));
            proxyUser = System.getProperty(protocol + ".proxyUser");
            proxyPassword = System.getProperty(protocol + ".proxyPassword");
            proxyAuthType = config.getProxyAuthType();
        }
        if (config.getHost() != null) {
            proxyHost = config.getHost();
            proxyPort = config.getPort();
            proxyUser = config.getUsername();
            proxyPassword = config.getPassword();
            proxyAuthType = config.getProxyAuthType();
            builder.setProxy(new HttpHost(proxyHost, (int)proxyPort));
        }
        if (proxyHost == null) {
            return;
        }
        if (config.getNonProxyHosts() != null) {
            builder.setRoutePlanner(new CustomRoutePlanner(new HttpHost(proxyHost, (int)proxyPort), config.getNonProxyHosts()));
        }
        ProxyUtils.setupProxyAuth(proxyHost, proxyPort, proxyAuthType, proxyUser, proxyPassword, builder);
    }

    public static void setupProxyAuth(String proxyHost, Integer proxyPort, ProxyConfig.ProxyAuthType proxyAuthType, String proxyUser, String proxyPassword, HttpClientBuilder builder) {
        if (proxyAuthType == null) {
            return;
        }
        AuthScope authScope = new AuthScope(proxyHost, proxyPort);
        switch (proxyAuthType) {
            case NONE: {
                break;
            }
            case BASIC: {
                ProxyUtils.setupBasicProxyAuth(builder, authScope, proxyUser, proxyPassword);
                break;
            }
            case SPNEGO: {
                ProxyUtils.setupNegotiateProxyAuth(builder, authScope);
                break;
            }
            default: {
                throw new DatabricksException("Unknown proxy auth type: " + (Object)((Object)proxyAuthType));
            }
        }
    }

    public static void setupNegotiateProxyAuth(HttpClientBuilder builder, AuthScope authScope) {
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        Credentials useJaasCreds = new Credentials(){

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public Principal getUserPrincipal() {
                return null;
            }
        };
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(authScope, useJaasCreds);
        builder.setDefaultCredentialsProvider(credsProvider).setDefaultAuthSchemeRegistry(RegistryBuilder.create().register("Negotiate", new SPNegoSchemeFactory(true, false)).build());
    }

    public static void setupBasicProxyAuth(HttpClientBuilder builder, AuthScope authScope, String proxyUser, String proxyPassword) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(authScope, new UsernamePasswordCredentials(proxyUser, proxyPassword));
        builder.setDefaultCredentialsProvider(credsProvider).setProxyAuthenticationStrategy(new ProxyAuthenticationStrategy());
    }
}

