/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.CreateEntityTagAssignmentRequest;
import com.databricks.internal.sdk.service.catalog.DeleteEntityTagAssignmentRequest;
import com.databricks.internal.sdk.service.catalog.EntityTagAssignment;
import com.databricks.internal.sdk.service.catalog.EntityTagAssignmentsService;
import com.databricks.internal.sdk.service.catalog.GetEntityTagAssignmentRequest;
import com.databricks.internal.sdk.service.catalog.ListEntityTagAssignmentsRequest;
import com.databricks.internal.sdk.service.catalog.ListEntityTagAssignmentsResponse;
import com.databricks.internal.sdk.service.catalog.UpdateEntityTagAssignmentRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class EntityTagAssignmentsImpl
implements EntityTagAssignmentsService {
    private final ApiClient apiClient;

    public EntityTagAssignmentsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public EntityTagAssignment create(CreateEntityTagAssignmentRequest request) {
        String path = "/api/2.1/unity-catalog/entity-tag-assignments";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getTagAssignment()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, EntityTagAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteEntityTagAssignmentRequest request) {
        String path = String.format("/api/2.1/unity-catalog/entity-tag-assignments/%s/%s/tags/%s", request.getEntityType(), request.getEntityName(), request.getTagKey());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public EntityTagAssignment get(GetEntityTagAssignmentRequest request) {
        String path = String.format("/api/2.1/unity-catalog/entity-tag-assignments/%s/%s/tags/%s", request.getEntityType(), request.getEntityName(), request.getTagKey());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, EntityTagAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListEntityTagAssignmentsResponse list(ListEntityTagAssignmentsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/entity-tag-assignments/%s/%s/tags", request.getEntityType(), request.getEntityName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListEntityTagAssignmentsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public EntityTagAssignment update(UpdateEntityTagAssignmentRequest request) {
        String path = String.format("/api/2.1/unity-catalog/entity-tag-assignments/%s/%s/tags/%s", request.getEntityType(), request.getEntityName(), request.getTagKey());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getTagAssignment()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, EntityTagAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

