/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.CreateSchema;
import com.databricks.internal.sdk.service.catalog.DeleteSchemaRequest;
import com.databricks.internal.sdk.service.catalog.GetSchemaRequest;
import com.databricks.internal.sdk.service.catalog.ListSchemasRequest;
import com.databricks.internal.sdk.service.catalog.ListSchemasResponse;
import com.databricks.internal.sdk.service.catalog.SchemaInfo;
import com.databricks.internal.sdk.service.catalog.SchemasService;
import com.databricks.internal.sdk.service.catalog.UpdateSchema;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class SchemasImpl
implements SchemasService {
    private final ApiClient apiClient;

    public SchemasImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public SchemaInfo create(CreateSchema request) {
        String path = "/api/2.1/unity-catalog/schemas";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, SchemaInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteSchemaRequest request) {
        String path = String.format("/api/2.1/unity-catalog/schemas/%s", request.getFullName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public SchemaInfo get(GetSchemaRequest request) {
        String path = String.format("/api/2.1/unity-catalog/schemas/%s", request.getFullName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, SchemaInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListSchemasResponse list(ListSchemasRequest request) {
        String path = "/api/2.1/unity-catalog/schemas";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListSchemasResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public SchemaInfo update(UpdateSchema request) {
        String path = String.format("/api/2.1/unity-catalog/schemas/%s", request.getFullName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, SchemaInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

