/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.cleanrooms;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAsset;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAssetAssetType;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAssetRevisionsImpl;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAssetRevisionsService;
import com.databricks.internal.sdk.service.cleanrooms.GetCleanRoomAssetRevisionRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAssetRevisionsRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAssetRevisionsResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CleanRoomAssetRevisionsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CleanRoomAssetRevisionsAPI.class);
    private final CleanRoomAssetRevisionsService impl;

    public CleanRoomAssetRevisionsAPI(ApiClient apiClient) {
        this.impl = new CleanRoomAssetRevisionsImpl(apiClient);
    }

    public CleanRoomAssetRevisionsAPI(CleanRoomAssetRevisionsService mock) {
        this.impl = mock;
    }

    public CleanRoomAsset get(String cleanRoomName, CleanRoomAssetAssetType assetType, String name, String etag) {
        return this.get(new GetCleanRoomAssetRevisionRequest().setCleanRoomName(cleanRoomName).setAssetType(assetType).setName(name).setEtag(etag));
    }

    public CleanRoomAsset get(GetCleanRoomAssetRevisionRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CleanRoomAsset> list(String cleanRoomName, CleanRoomAssetAssetType assetType, String name) {
        return this.list(new ListCleanRoomAssetRevisionsRequest().setCleanRoomName(cleanRoomName).setAssetType(assetType).setName(name));
    }

    public Iterable<CleanRoomAsset> list(ListCleanRoomAssetRevisionsRequest request) {
        return new Paginator(request, this.impl::list, ListCleanRoomAssetRevisionsResponse::getRevisions, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CleanRoomAssetRevisionsService impl() {
        return this.impl;
    }
}

