/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.compute.AddInstanceProfile;
import com.databricks.internal.sdk.service.compute.InstanceProfile;
import com.databricks.internal.sdk.service.compute.InstanceProfilesImpl;
import com.databricks.internal.sdk.service.compute.InstanceProfilesService;
import com.databricks.internal.sdk.service.compute.ListInstanceProfilesResponse;
import com.databricks.internal.sdk.service.compute.RemoveInstanceProfile;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class InstanceProfilesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceProfilesAPI.class);
    private final InstanceProfilesService impl;

    public InstanceProfilesAPI(ApiClient apiClient) {
        this.impl = new InstanceProfilesImpl(apiClient);
    }

    public InstanceProfilesAPI(InstanceProfilesService mock) {
        this.impl = mock;
    }

    public void add(AddInstanceProfile request) {
        this.impl.add(request);
    }

    public void edit(InstanceProfile request) {
        this.impl.edit(request);
    }

    public Iterable<InstanceProfile> list() {
        return new Paginator(null, v -> this.impl.list(), ListInstanceProfilesResponse::getInstanceProfiles, response -> null);
    }

    public void remove(String instanceProfileArn) {
        this.remove(new RemoveInstanceProfile().setInstanceProfileArn(instanceProfileArn));
    }

    public void remove(RemoveInstanceProfile request) {
        this.impl.remove(request);
    }

    public InstanceProfilesService impl() {
        return this.impl;
    }
}

