/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.io.ParseException;
import com.databricks.internal.jts.io.WKBReader;
import com.databricks.internal.jts.io.WKBWriter;
import com.databricks.internal.jts.io.WKTReader;
import com.databricks.internal.jts.io.WKTWriter;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;

public class WKTConverter {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(WKTConverter.class);
    private static final ThreadLocal<WKTReader> WKT_READER = ThreadLocal.withInitial(WKTReader::new);
    private static final ThreadLocal<WKTWriter> WKT_WRITER = ThreadLocal.withInitial(WKTWriter::new);
    private static final ThreadLocal<WKBReader> WKB_READER = ThreadLocal.withInitial(WKBReader::new);
    private static final ThreadLocal<WKBWriter> WKB_WRITER = ThreadLocal.withInitial(WKBWriter::new);

    public static byte[] toWKB(String wkt) throws DatabricksValidationException {
        if (wkt == null || wkt.trim().isEmpty()) {
            throw new DatabricksValidationException("WKT string cannot be null or empty");
        }
        try {
            Geometry geometry = WKT_READER.get().read(wkt);
            return WKB_WRITER.get().write(geometry);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Invalid WKT format: %s", wkt);
            LOGGER.error(errorMessage, e);
            throw new DatabricksValidationException(errorMessage, e);
        }
    }

    public static String toWKT(byte[] wkb) throws DatabricksValidationException {
        if (wkb == null || wkb.length == 0) {
            throw new DatabricksValidationException("WKB bytes cannot be null or empty");
        }
        try {
            Geometry geometry = WKB_READER.get().read(wkb);
            return WKT_WRITER.get().write(geometry);
        }
        catch (Exception e) {
            String errorMessage = String.format("Invalid WKB format: %d bytes", wkb.length);
            LOGGER.error(errorMessage, e);
            throw new DatabricksValidationException(errorMessage, e);
        }
    }

    public static int extractSRIDFromEWKT(String ewkt) {
        int semicolonIndex;
        if (ewkt == null || ewkt.trim().isEmpty()) {
            return 0;
        }
        String trimmed = ewkt.trim();
        if (trimmed.startsWith("SRID=") && (semicolonIndex = trimmed.indexOf(59)) > 0) {
            try {
                String sridStr = trimmed.substring(5, semicolonIndex);
                return Integer.parseInt(sridStr);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid SRID format in EWKT: {}", ewkt);
                return 0;
            }
        }
        return 0;
    }

    public static String removeSRIDFromEWKT(String ewkt) {
        int semicolonIndex;
        if (ewkt == null || ewkt.trim().isEmpty()) {
            return ewkt;
        }
        String trimmed = ewkt.trim();
        if (trimmed.startsWith("SRID=") && (semicolonIndex = trimmed.indexOf(59)) > 0) {
            return trimmed.substring(semicolonIndex + 1);
        }
        return trimmed;
    }
}

