/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.volume;

import com.databricks.internal.apache.hc.core5.http.ContentType;
import com.databricks.internal.apache.hc.core5.http.nio.AsyncEntityProducer;
import com.databricks.internal.apache.hc.core5.http.nio.DataStreamChannel;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class InputStreamFixedLenProducer
implements AsyncEntityProducer,
Closeable {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(InputStreamFixedLenProducer.class);
    private static final int DEFAULT_BUF = 16384;
    private final InputStream source;
    private final long contentLength;
    private final byte[] buf;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicReference<Exception> failure = new AtomicReference();
    private ByteBuffer currentChunk = null;
    private long totalBytesRead = 0L;

    public InputStreamFixedLenProducer(InputStream source, long contentLength, int bufferSize) {
        this.source = Objects.requireNonNull(source, "source must not be null");
        if (contentLength < 0L) {
            throw new IllegalArgumentException("contentLength must be \u22650");
        }
        this.contentLength = contentLength;
        this.buf = new byte[Math.max(bufferSize, 16384)];
    }

    public InputStreamFixedLenProducer(InputStream source, long contentLength) {
        this(source, contentLength, 16384);
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return ContentType.APPLICATION_OCTET_STREAM.toString();
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.closed.get()) {
            return;
        }
        try {
            if (this.currentChunk != null) {
                channel.write(this.currentChunk);
                if (this.currentChunk.hasRemaining()) {
                    channel.requestOutput();
                    return;
                }
                this.currentChunk = null;
            }
            if (this.totalBytesRead >= this.contentLength) {
                channel.endStream();
                this.releaseResources();
                return;
            }
            int toRead = (int)Math.min((long)this.buf.length, this.contentLength - this.totalBytesRead);
            int bytesRead = this.source.read(this.buf, 0, toRead);
            if (bytesRead == -1) {
                throw new IOException(String.format("Unexpected end of stream. Read %d bytes, but expected %d.", this.totalBytesRead, this.contentLength));
            }
            this.totalBytesRead += (long)bytesRead;
            this.currentChunk = ByteBuffer.wrap(this.buf, 0, bytesRead);
            channel.write(this.currentChunk);
            if (this.currentChunk.hasRemaining()) {
                channel.requestOutput();
            } else {
                this.currentChunk = null;
                if (this.totalBytesRead >= this.contentLength) {
                    channel.endStream();
                    this.releaseResources();
                }
            }
        }
        catch (Exception ex) {
            channel.endStream();
            if (this.failure.compareAndSet(null, ex)) {
                LOGGER.error(ex, "Upload failed after reading {} bytes", this.totalBytesRead);
                this.releaseResources();
            }
            throw ex;
        }
    }

    @Override
    public void failed(Exception cause) {
        if (this.failure.compareAndSet(null, cause)) {
            LOGGER.error(cause, "Upload failed due to an external cause after reading {} bytes", this.totalBytesRead);
            this.releaseResources();
        }
    }

    @Override
    public void releaseResources() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.source.close();
            }
            catch (IOException ioe) {
                LOGGER.warn("Error while closing upload stream", ioe);
            }
        }
    }

    @Override
    public void close() {
        this.releaseResources();
    }
}

