/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.jdbc.common.DatabricksJdbcConstants;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class InsertStatementParser {
    private static final Pattern INSERT_DETAILS_PATTERN = Pattern.compile("^\\s*INSERT\\s+INTO\\s+([\\w`\\.]+)\\s*\\(([^)]+)\\)\\s+VALUES\\s*\\(", 34);

    public static InsertInfo parseInsert(String sql) {
        try {
            return InsertStatementParser.parseInsertStrict(sql);
        }
        catch (DatabricksParsingException e) {
            return null;
        }
    }

    public static InsertInfo parseInsertStrict(String sql) throws DatabricksParsingException {
        if (sql == null || sql.trim().isEmpty()) {
            throw new DatabricksParsingException("SQL statement cannot be null or empty", DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        String trimmedSql = sql.trim();
        if (!DatabricksJdbcConstants.INSERT_PATTERN.matcher(trimmedSql).find()) {
            throw new DatabricksParsingException("SQL statement is not an INSERT operation: " + trimmedSql, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        Matcher matcher = INSERT_DETAILS_PATTERN.matcher(trimmedSql);
        if (!matcher.find()) {
            throw new DatabricksParsingException("INSERT statement does not match the expected format 'INSERT INTO table (columns) VALUES': " + trimmedSql, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        String tableName = matcher.group(1).trim();
        String columnsStr = matcher.group(2).trim();
        List<String> columns = InsertStatementParser.parseColumns(columnsStr);
        if (columns.isEmpty()) {
            throw new DatabricksParsingException("INSERT statement does not contain any valid column names: " + trimmedSql, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        return new InsertInfo(tableName, columns, trimmedSql);
    }

    private static List<String> parseColumns(String columnsStr) {
        return Arrays.stream(columnsStr.split(",")).map(String::trim).map(col -> col.replaceAll("^`|`$", "")).filter(col -> !col.isEmpty()).collect(Collectors.toList());
    }

    public static boolean isParametrizedInsert(String sql) {
        if (sql == null || !DatabricksJdbcConstants.INSERT_PATTERN.matcher(sql.trim()).find()) {
            return false;
        }
        return sql.contains("?");
    }

    public static String generateMultiRowInsert(InsertInfo insertInfo, int numberOfRows) throws DatabricksParsingException {
        if (insertInfo == null) {
            throw new DatabricksParsingException("InsertInfo cannot be null", DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        if (numberOfRows <= 0) {
            throw new DatabricksParsingException("Number of rows must be positive, got: " + numberOfRows, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(insertInfo.getTableName()).append(" (").append(String.join((CharSequence)", ", insertInfo.getColumns())).append(") VALUES ");
        String valueClause = "(" + "?, ".repeat(insertInfo.getColumns().size() - 1) + "?)";
        for (int i = 0; i < numberOfRows; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(valueClause);
        }
        return sql.toString();
    }

    public static class InsertInfo {
        private final String tableName;
        private final List<String> columns;
        private final String originalSql;

        public InsertInfo(String tableName, List<String> columns, String originalSql) {
            this.tableName = tableName;
            this.columns = columns;
            this.originalSql = originalSql;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public String getOriginalSql() {
            return this.originalSql;
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public boolean isCompatibleWith(InsertInfo other) {
            return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.columns, other.columns);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InsertInfo that = (InsertInfo)o;
            return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.columns, that.columns);
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columns);
        }
    }
}

