/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient;

import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.ImmutableSessionInfo;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.telemetry.latency.DatabricksMetricsTimed;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

public interface IDatabricksClient {
    @DatabricksMetricsTimed
    public ImmutableSessionInfo createSession(IDatabricksComputeResource var1, String var2, String var3, Map<String, String> var4) throws DatabricksSQLException;

    @DatabricksMetricsTimed
    public void deleteSession(ImmutableSessionInfo var1) throws DatabricksSQLException;

    @DatabricksMetricsTimed
    public DatabricksResultSet executeStatement(String var1, IDatabricksComputeResource var2, Map<Integer, ImmutableSqlParameter> var3, StatementType var4, IDatabricksSession var5, IDatabricksStatementInternal var6) throws SQLException;

    @DatabricksMetricsTimed
    public DatabricksResultSet executeStatementAsync(String var1, IDatabricksComputeResource var2, Map<Integer, ImmutableSqlParameter> var3, IDatabricksSession var4, IDatabricksStatementInternal var5) throws SQLException;

    @DatabricksMetricsTimed
    public void closeStatement(StatementId var1) throws DatabricksSQLException;

    @DatabricksMetricsTimed
    public void cancelStatement(StatementId var1) throws DatabricksSQLException;

    public DatabricksResultSet getStatementResult(StatementId var1, IDatabricksSession var2, IDatabricksStatementInternal var3) throws SQLException;

    public Collection<ExternalLink> getResultChunks(StatementId var1, long var2) throws DatabricksSQLException;

    public ResultData getResultChunksData(StatementId var1, long var2) throws DatabricksSQLException;

    public IDatabricksConnectionContext getConnectionContext();

    public void resetAccessToken(String var1);

    public TFetchResultsResp getMoreResults(IDatabricksStatementInternal var1) throws DatabricksSQLException;

    public DatabricksConfig getDatabricksConfig();
}

