/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.common;

import com.databricks.jdbc.common.MetadataResultConstants;
import com.databricks.jdbc.dbclient.impl.common.ImportedKeysDatabricksResultSetAdapter;
import com.databricks.jdbc.model.core.ResultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class CrossReferenceKeysDatabricksResultSetAdapter
extends ImportedKeysDatabricksResultSetAdapter {
    private final String targetParentCatalogName;
    private final String targetParentNamespaceName;
    private final String targetParentTableName;

    public CrossReferenceKeysDatabricksResultSetAdapter(String targetParentCatalogName, String targetParentNamespaceName, String targetParentTableName) {
        this.targetParentCatalogName = targetParentCatalogName;
        this.targetParentNamespaceName = targetParentNamespaceName;
        this.targetParentTableName = targetParentTableName;
    }

    @Override
    public boolean includeRow(ResultSet resultSet, List<ResultColumn> columns) throws SQLException {
        ResultColumn parentCatalogNameColumn = this.mapColumn(MetadataResultConstants.PKTABLE_CAT);
        ResultColumn parentNamespaceColumn = this.mapColumn(MetadataResultConstants.PKTABLE_SCHEM);
        ResultColumn parentTableNameColumn = this.mapColumn(MetadataResultConstants.PKTABLE_NAME);
        boolean isParentCatalogMatching = resultSet.getString(parentCatalogNameColumn.getResultSetColumnName()).equals(this.targetParentCatalogName);
        boolean isParentNamespaceMatching = resultSet.getString(parentNamespaceColumn.getResultSetColumnName()).equals(this.targetParentNamespaceName);
        boolean isParentTableMatching = resultSet.getString(parentTableNameColumn.getResultSetColumnName()).equals(this.targetParentTableName);
        if (!(isParentTableMatching && isParentCatalogMatching && isParentNamespaceMatching)) {
            return false;
        }
        return super.includeRow(resultSet, columns);
    }
}

