/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.telemetry.CircuitBreakerTelemetryPushClient;
import com.databricks.jdbc.telemetry.ITelemetryClient;
import com.databricks.jdbc.telemetry.ITelemetryPushClient;
import com.databricks.jdbc.telemetry.NoopTelemetryClient;
import com.databricks.jdbc.telemetry.TelemetryClient;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import com.databricks.jdbc.telemetry.TelemetryPushClient;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TelemetryClientFactory {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(TelemetryClientFactory.class);
    private static final String DEFAULT_HOST = "unknown-host";
    private static final TelemetryClientFactory INSTANCE = new TelemetryClientFactory();
    @VisibleForTesting
    final LinkedHashMap<String, TelemetryClient> telemetryClients = new LinkedHashMap();
    @VisibleForTesting
    final LinkedHashMap<String, TelemetryClient> noauthTelemetryClients = new LinkedHashMap();
    private final ExecutorService telemetryExecutorService = Executors.newFixedThreadPool(10, TelemetryClientFactory.createThreadFactory());

    private static ThreadFactory createThreadFactory() {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Telemetry-Thread-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    private TelemetryClientFactory() {
    }

    public static TelemetryClientFactory getInstance() {
        return INSTANCE;
    }

    public ITelemetryClient getTelemetryClient(IDatabricksConnectionContext connectionContext) {
        if (!TelemetryHelper.isTelemetryAllowedForConnection(connectionContext)) {
            return NoopTelemetryClient.getInstance();
        }
        DatabricksConfig databricksConfig = TelemetryHelper.getDatabricksConfigSafely(connectionContext);
        if (databricksConfig != null) {
            return this.telemetryClients.computeIfAbsent(connectionContext.getConnectionUuid(), k -> new TelemetryClient(connectionContext, this.getTelemetryExecutorService(), databricksConfig));
        }
        return this.noauthTelemetryClients.computeIfAbsent(connectionContext.getConnectionUuid(), k -> new TelemetryClient(connectionContext, this.getTelemetryExecutorService()));
    }

    public void closeTelemetryClient(IDatabricksConnectionContext connectionContext) {
        this.closeTelemetryClient((ITelemetryClient)this.telemetryClients.remove(connectionContext.getConnectionUuid()), "telemetry client");
        this.closeTelemetryClient((ITelemetryClient)this.noauthTelemetryClients.remove(connectionContext.getConnectionUuid()), "unauthenticated telemetry client");
    }

    public ExecutorService getTelemetryExecutorService() {
        return this.telemetryExecutorService;
    }

    static ITelemetryPushClient getTelemetryPushClient(Boolean isAuthenticated, IDatabricksConnectionContext connectionContext, DatabricksConfig databricksConfig) {
        ITelemetryPushClient pushClient = new TelemetryPushClient(isAuthenticated, connectionContext, databricksConfig);
        if (connectionContext.isTelemetryCircuitBreakerEnabled()) {
            String host = null;
            try {
                host = connectionContext.getHostUrl();
            }
            catch (DatabricksParsingException e) {
                LOGGER.error(e, "Error parsing host url");
                host = DEFAULT_HOST;
            }
            pushClient = new CircuitBreakerTelemetryPushClient(pushClient, host);
        }
        return pushClient;
    }

    @VisibleForTesting
    public void reset() {
        this.telemetryClients.values().forEach(TelemetryClient::close);
        this.noauthTelemetryClients.values().forEach(TelemetryClient::close);
        this.telemetryClients.clear();
        this.noauthTelemetryClients.clear();
    }

    private void closeTelemetryClient(ITelemetryClient client, String clientType) {
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception e) {
                LOGGER.debug("Caught error while closing {}. Error: {}", clientType, e);
            }
        }
    }
}

