/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.jcajce.provider.asymmetric.mlkem;

import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.databricks.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import com.databricks.internal.bouncycastle.jcajce.provider.asymmetric.mlkem.BCMLKEMPrivateKey;
import com.databricks.internal.bouncycastle.jcajce.provider.asymmetric.mlkem.BCMLKEMPublicKey;
import com.databricks.internal.bouncycastle.jcajce.spec.MLKEMParameterSpec;
import com.databricks.internal.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import com.databricks.internal.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import com.databricks.internal.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import com.databricks.internal.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class MLKEMKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    MLKEMKeyGenerationParameters param;
    MLKEMKeyPairGenerator engine = new MLKEMKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;
    private MLKEMParameters kyberParameters;

    public MLKEMKeyPairGeneratorSpi() {
        super("ML-KEM");
    }

    protected MLKEMKeyPairGeneratorSpi(MLKEMParameterSpec mLKEMParameterSpec) {
        super(Strings.toUpperCase(mLKEMParameterSpec.getName()));
        this.kyberParameters = (MLKEMParameters)parameters.get(mLKEMParameterSpec.getName());
        if (this.param == null) {
            this.param = new MLKEMKeyGenerationParameters(this.random, this.kyberParameters);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = MLKEMKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        MLKEMParameters mLKEMParameters = (MLKEMParameters)parameters.get(string);
        if (string != null) {
            this.param = new MLKEMKeyGenerationParameters(secureRandom, (MLKEMParameters)parameters.get(string));
            if (this.kyberParameters != null && !mLKEMParameters.getName().equals(this.kyberParameters.getName())) {
                throw new InvalidAlgorithmParameterException("key pair generator locked to " + this.getAlgorithm());
            }
        } else {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new MLKEMKeyGenerationParameters(this.random, MLKEMParameters.ml_kem_768);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        MLKEMPublicKeyParameters mLKEMPublicKeyParameters = (MLKEMPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        MLKEMPrivateKeyParameters mLKEMPrivateKeyParameters = (MLKEMPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCMLKEMPublicKey(mLKEMPublicKeyParameters), new BCMLKEMPrivateKey(mLKEMPrivateKeyParameters));
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof MLKEMParameterSpec) {
            MLKEMParameterSpec mLKEMParameterSpec = (MLKEMParameterSpec)algorithmParameterSpec;
            return mLKEMParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    static {
        parameters.put(MLKEMParameterSpec.ml_kem_512.getName(), MLKEMParameters.ml_kem_512);
        parameters.put(MLKEMParameterSpec.ml_kem_768.getName(), MLKEMParameters.ml_kem_768);
        parameters.put(MLKEMParameterSpec.ml_kem_1024.getName(), MLKEMParameters.ml_kem_1024);
    }

    public static class MLKEM1024
    extends MLKEMKeyPairGeneratorSpi {
        public MLKEM1024() {
            super(MLKEMParameterSpec.ml_kem_1024);
        }
    }

    public static class MLKEM512
    extends MLKEMKeyPairGeneratorSpi {
        public MLKEM512() {
            super(MLKEMParameterSpec.ml_kem_512);
        }
    }

    public static class MLKEM768
    extends MLKEMKeyPairGeneratorSpi {
        public MLKEM768() {
            super(MLKEMParameterSpec.ml_kem_768);
        }
    }
}

