/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.oer.its.ieee1609dot2.basetypes;

import com.databricks.internal.bouncycastle.asn1.ASN1Choice;
import com.databricks.internal.bouncycastle.asn1.ASN1Encodable;
import com.databricks.internal.bouncycastle.asn1.ASN1Object;
import com.databricks.internal.bouncycastle.asn1.ASN1Primitive;
import com.databricks.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.databricks.internal.bouncycastle.asn1.DERTaggedObject;
import com.databricks.internal.bouncycastle.oer.its.ieee1609dot2.basetypes.EccCurvePoint;
import com.databricks.internal.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP256CurvePoint;

public class BasePublicEncryptionKey
extends ASN1Object
implements ASN1Choice {
    public static final int eciesNistP256 = 0;
    public static final int eciesBrainpoolP256r1 = 1;
    private final int choice;
    private final ASN1Encodable basePublicEncryptionKey;

    private BasePublicEncryptionKey(ASN1TaggedObject aSN1TaggedObject) {
        this.choice = aSN1TaggedObject.getTagNo();
        switch (this.choice) {
            case 0: 
            case 1: {
                this.basePublicEncryptionKey = EccP256CurvePoint.getInstance(aSN1TaggedObject.getExplicitBaseObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid choice value " + aSN1TaggedObject.getTagNo());
            }
        }
    }

    public BasePublicEncryptionKey(int n, ASN1Encodable aSN1Encodable) {
        this.choice = n;
        this.basePublicEncryptionKey = aSN1Encodable;
    }

    public static BasePublicEncryptionKey getInstance(Object object) {
        if (object instanceof BasePublicEncryptionKey) {
            return (BasePublicEncryptionKey)object;
        }
        if (object != null) {
            return new BasePublicEncryptionKey(ASN1TaggedObject.getInstance(object, 128));
        }
        return null;
    }

    public static BasePublicEncryptionKey eciesNistP256(EccP256CurvePoint eccP256CurvePoint) {
        return new BasePublicEncryptionKey(0, eccP256CurvePoint);
    }

    public static BasePublicEncryptionKey eciesBrainpoolP256r1(EccP256CurvePoint eccP256CurvePoint) {
        return new BasePublicEncryptionKey(1, eccP256CurvePoint);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getBasePublicEncryptionKey() {
        return this.basePublicEncryptionKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.basePublicEncryptionKey);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        public Builder setChoice(int n) {
            this.choice = n;
            return this;
        }

        public Builder setValue(EccCurvePoint eccCurvePoint) {
            this.value = eccCurvePoint;
            return this;
        }

        public BasePublicEncryptionKey createBasePublicEncryptionKey() {
            return new BasePublicEncryptionKey(this.choice, this.value);
        }
    }
}

