/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.io.github.resilience4j.circuitbreaker;

import com.databricks.internal.io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.IllegalStateTransitionException;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnFailureRateExceededEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnResetEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSlowCallRateExceededEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import com.databricks.internal.io.github.resilience4j.core.EventConsumer;
import com.databricks.internal.io.github.resilience4j.core.functions.OnceConsumer;
import com.databricks.internal.io.vavr.CheckedConsumer;
import com.databricks.internal.io.vavr.CheckedFunction0;
import com.databricks.internal.io.vavr.CheckedFunction1;
import com.databricks.internal.io.vavr.CheckedRunnable;
import com.databricks.internal.io.vavr.Tuple;
import com.databricks.internal.io.vavr.Tuple2;
import com.databricks.internal.io.vavr.control.Either;
import com.databricks.internal.io.vavr.control.Try;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface CircuitBreaker {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(CircuitBreaker circuitBreaker, CheckedFunction0<T> supplier) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                Object result = supplier.apply();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), result);
                return result;
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(CircuitBreaker circuitBreaker, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            if (!circuitBreaker.tryAcquirePermission()) {
                promise.completeExceptionally(CallNotPermittedException.createCallNotPermittedException(circuitBreaker));
            } else {
                long start = circuitBreaker.getCurrentTimestamp();
                try {
                    ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                        long duration = circuitBreaker.getCurrentTimestamp() - start;
                        if (throwable != null) {
                            if (throwable instanceof Exception) {
                                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), (Throwable)throwable);
                            }
                            promise.completeExceptionally((Throwable)throwable);
                        } else {
                            circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), result);
                            promise.complete(result);
                        }
                    });
                }
                catch (Exception exception) {
                    long duration = circuitBreaker.getCurrentTimestamp() - start;
                    circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                    promise.completeExceptionally(exception);
                }
            }
            return promise;
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(CircuitBreaker circuitBreaker, CheckedRunnable runnable) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                runnable.run();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(CircuitBreaker circuitBreaker, Callable<T> callable) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                Object result = callable.call();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), result);
                return result;
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(CircuitBreaker circuitBreaker, Supplier<T> supplier) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                Object result = supplier.get();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), result);
                return result;
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(CircuitBreaker circuitBreaker, Supplier<Either<? extends Exception, T>> supplier) {
        return () -> {
            if (circuitBreaker.tryAcquirePermission()) {
                long start = circuitBreaker.getCurrentTimestamp();
                Either result = (Either)supplier.get();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                if (result.isRight()) {
                    circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), result);
                } else {
                    Exception exception = (Exception)result.getLeft();
                    circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                }
                return Either.narrow(result);
            }
            return Either.left(CallNotPermittedException.createCallNotPermittedException(circuitBreaker));
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(CircuitBreaker circuitBreaker, Supplier<Try<T>> supplier) {
        return () -> {
            if (circuitBreaker.tryAcquirePermission()) {
                long start = circuitBreaker.getCurrentTimestamp();
                Try result = (Try)supplier.get();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                if (result.isSuccess()) {
                    circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), result);
                } else {
                    circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), result.getCause());
                }
                return result;
            }
            return Try.failure(CallNotPermittedException.createCallNotPermittedException(circuitBreaker));
        };
    }

    public static <T> Consumer<T> decorateConsumer(CircuitBreaker circuitBreaker, Consumer<T> consumer) {
        return t2 -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                consumer.accept(t2);
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(CircuitBreaker circuitBreaker, CheckedConsumer<T> consumer) {
        return t2 -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                consumer.accept(t2);
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static Runnable decorateRunnable(CircuitBreaker circuitBreaker, Runnable runnable) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                runnable.run();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(CircuitBreaker circuitBreaker, Function<T, R> function) {
        return t2 -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                Object returnValue = function.apply(t2);
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), returnValue);
                return returnValue;
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(CircuitBreaker circuitBreaker, CheckedFunction1<T, R> function) {
        return t2 -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                Object returnValue = function.apply(t2);
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onResult(duration, circuitBreaker.getTimestampUnit(), returnValue);
                return returnValue;
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), exception);
                throw exception;
            }
        };
    }

    public static CircuitBreaker ofDefaults(String name) {
        return new CircuitBreakerStateMachine(name);
    }

    public static CircuitBreaker of(String name, CircuitBreakerConfig circuitBreakerConfig) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfig);
    }

    public static CircuitBreaker of(String name, CircuitBreakerConfig circuitBreakerConfig, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfig, tags);
    }

    public static CircuitBreaker of(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfigSupplier);
    }

    public static CircuitBreaker of(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfigSupplier, tags);
    }

    public static <T> Supplier<Future<T>> decorateFuture(CircuitBreaker circuitBreaker, Supplier<Future<T>> supplier) {
        return () -> {
            if (!circuitBreaker.tryAcquirePermission()) {
                CompletableFuture promise = new CompletableFuture();
                promise.completeExceptionally(CallNotPermittedException.createCallNotPermittedException(circuitBreaker));
                return promise;
            }
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                return new CircuitBreakerFuture(circuitBreaker, (Future)supplier.get(), start);
            }
            catch (Exception e) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), e);
                throw e;
            }
        };
    }

    public boolean tryAcquirePermission();

    public void releasePermission();

    public void acquirePermission();

    public void onError(long var1, TimeUnit var3, Throwable var4);

    public void onSuccess(long var1, TimeUnit var3);

    public void onResult(long var1, TimeUnit var3, Object var4);

    public void reset();

    public void transitionToClosedState();

    public void transitionToOpenState();

    public void transitionToHalfOpenState();

    public void transitionToDisabledState();

    public void transitionToMetricsOnlyState();

    public void transitionToForcedOpenState();

    public String getName();

    public State getState();

    public CircuitBreakerConfig getCircuitBreakerConfig();

    public Metrics getMetrics();

    public com.databricks.internal.io.vavr.collection.Map<String, String> getTags();

    public EventPublisher getEventPublisher();

    public long getCurrentTimestamp();

    public TimeUnit getTimestampUnit();

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return CircuitBreaker.decorateSupplier(this, supplier).get();
    }

    default public <T> Supplier<T> decorateSupplier(Supplier<T> supplier) {
        return CircuitBreaker.decorateSupplier(this, supplier);
    }

    default public <T> Either<Exception, T> executeEitherSupplier(Supplier<Either<? extends Exception, T>> supplier) {
        return CircuitBreaker.decorateEitherSupplier(this, supplier).get();
    }

    default public <T> Supplier<Try<T>> decorateTrySupplier(Supplier<Try<T>> supplier) {
        return CircuitBreaker.decorateTrySupplier(this, supplier);
    }

    default public <T> Try<T> executeTrySupplier(Supplier<Try<T>> supplier) {
        return CircuitBreaker.decorateTrySupplier(this, supplier).get();
    }

    default public <T> Supplier<Either<Exception, T>> decorateEitherSupplier(Supplier<Either<? extends Exception, T>> supplier) {
        return CircuitBreaker.decorateEitherSupplier(this, supplier);
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return CircuitBreaker.decorateCallable(this, callable).call();
    }

    default public <T> Callable<T> decorateCallable(Callable<T> callable) {
        return CircuitBreaker.decorateCallable(this, callable);
    }

    default public void executeRunnable(Runnable runnable) {
        CircuitBreaker.decorateRunnable(this, runnable).run();
    }

    default public Runnable decorateRunnable(Runnable runnable) {
        return CircuitBreaker.decorateRunnable(this, runnable);
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return CircuitBreaker.decorateCompletionStage(this, supplier).get();
    }

    default public <T> Supplier<CompletionStage<T>> decorateCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return CircuitBreaker.decorateCompletionStage(this, supplier);
    }

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return CircuitBreaker.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    default public <T> CheckedFunction0<T> decorateCheckedSupplier(CheckedFunction0<T> checkedSupplier) {
        return CircuitBreaker.decorateCheckedSupplier(this, checkedSupplier);
    }

    default public CheckedRunnable decorateCheckedRunnable(CheckedRunnable runnable) {
        return CircuitBreaker.decorateCheckedRunnable(this, runnable);
    }

    default public void executeCheckedRunnable(CheckedRunnable runnable) throws Throwable {
        CircuitBreaker.decorateCheckedRunnable(this, runnable).run();
    }

    default public <T> Consumer<T> decorateConsumer(Consumer<T> consumer) {
        return CircuitBreaker.decorateConsumer(this, consumer);
    }

    default public <T> CheckedConsumer<T> decorateCheckedConsumer(CheckedConsumer<T> consumer) {
        return CircuitBreaker.decorateCheckedConsumer(this, consumer);
    }

    default public <T> Supplier<Future<T>> decorateFuture(Supplier<Future<T>> supplier) {
        return CircuitBreaker.decorateFuture(this, supplier);
    }

    public static final class CircuitBreakerFuture<T>
    implements Future<T> {
        private final Future<T> future;
        private final OnceConsumer<CircuitBreaker> onceToCircuitbreaker;
        private final long start;

        CircuitBreakerFuture(CircuitBreaker circuitBreaker, Future<T> future) {
            this(circuitBreaker, future, circuitBreaker.getCurrentTimestamp());
        }

        CircuitBreakerFuture(CircuitBreaker circuitBreaker, Future<T> future, long start) {
            Objects.requireNonNull(future, "Non null Future is required to decorate");
            this.onceToCircuitbreaker = OnceConsumer.of(circuitBreaker);
            this.future = future;
            this.start = start;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                T v = this.future.get();
                this.onceToCircuitbreaker.applyOnce(cb -> cb.onResult(cb.getCurrentTimestamp() - this.start, cb.getTimestampUnit(), v));
                return v;
            }
            catch (InterruptedException | CancellationException e) {
                this.onceToCircuitbreaker.applyOnce(cb -> cb.releasePermission());
                throw e;
            }
            catch (Exception e) {
                this.onceToCircuitbreaker.applyOnce(cb -> cb.onError(cb.getCurrentTimestamp() - this.start, cb.getTimestampUnit(), e));
                throw e;
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                T v = this.future.get(timeout, unit);
                this.onceToCircuitbreaker.applyOnce(cb -> cb.onResult(cb.getCurrentTimestamp() - this.start, cb.getTimestampUnit(), v));
                return v;
            }
            catch (InterruptedException | CancellationException e) {
                this.onceToCircuitbreaker.applyOnce(CircuitBreaker::releasePermission);
                throw e;
            }
            catch (Exception e) {
                this.onceToCircuitbreaker.applyOnce(cb -> cb.onError(cb.getCurrentTimestamp() - this.start, cb.getTimestampUnit(), e));
                throw e;
            }
        }
    }

    public static interface Metrics {
        public float getFailureRate();

        public float getSlowCallRate();

        public int getNumberOfSlowCalls();

        public int getNumberOfSlowSuccessfulCalls();

        public int getNumberOfSlowFailedCalls();

        public int getNumberOfBufferedCalls();

        public int getNumberOfFailedCalls();

        public long getNumberOfNotPermittedCalls();

        public int getNumberOfSuccessfulCalls();
    }

    public static interface EventPublisher
    extends com.databricks.internal.io.github.resilience4j.core.EventPublisher<CircuitBreakerEvent> {
        public EventPublisher onSuccess(EventConsumer<CircuitBreakerOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<CircuitBreakerOnErrorEvent> var1);

        public EventPublisher onStateTransition(EventConsumer<CircuitBreakerOnStateTransitionEvent> var1);

        public EventPublisher onReset(EventConsumer<CircuitBreakerOnResetEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<CircuitBreakerOnIgnoredErrorEvent> var1);

        public EventPublisher onCallNotPermitted(EventConsumer<CircuitBreakerOnCallNotPermittedEvent> var1);

        public EventPublisher onFailureRateExceeded(EventConsumer<CircuitBreakerOnFailureRateExceededEvent> var1);

        public EventPublisher onSlowCallRateExceeded(EventConsumer<CircuitBreakerOnSlowCallRateExceededEvent> var1);
    }

    public static enum StateTransition {
        CLOSED_TO_CLOSED(State.CLOSED, State.CLOSED),
        CLOSED_TO_OPEN(State.CLOSED, State.OPEN),
        CLOSED_TO_DISABLED(State.CLOSED, State.DISABLED),
        CLOSED_TO_METRICS_ONLY(State.CLOSED, State.METRICS_ONLY),
        CLOSED_TO_FORCED_OPEN(State.CLOSED, State.FORCED_OPEN),
        HALF_OPEN_TO_HALF_OPEN(State.HALF_OPEN, State.HALF_OPEN),
        HALF_OPEN_TO_CLOSED(State.HALF_OPEN, State.CLOSED),
        HALF_OPEN_TO_OPEN(State.HALF_OPEN, State.OPEN),
        HALF_OPEN_TO_DISABLED(State.HALF_OPEN, State.DISABLED),
        HALF_OPEN_TO_METRICS_ONLY(State.HALF_OPEN, State.METRICS_ONLY),
        HALF_OPEN_TO_FORCED_OPEN(State.HALF_OPEN, State.FORCED_OPEN),
        OPEN_TO_OPEN(State.OPEN, State.OPEN),
        OPEN_TO_CLOSED(State.OPEN, State.CLOSED),
        OPEN_TO_HALF_OPEN(State.OPEN, State.HALF_OPEN),
        OPEN_TO_DISABLED(State.OPEN, State.DISABLED),
        OPEN_TO_METRICS_ONLY(State.OPEN, State.METRICS_ONLY),
        OPEN_TO_FORCED_OPEN(State.OPEN, State.FORCED_OPEN),
        FORCED_OPEN_TO_FORCED_OPEN(State.FORCED_OPEN, State.FORCED_OPEN),
        FORCED_OPEN_TO_CLOSED(State.FORCED_OPEN, State.CLOSED),
        FORCED_OPEN_TO_OPEN(State.FORCED_OPEN, State.OPEN),
        FORCED_OPEN_TO_DISABLED(State.FORCED_OPEN, State.DISABLED),
        FORCED_OPEN_TO_METRICS_ONLY(State.FORCED_OPEN, State.METRICS_ONLY),
        FORCED_OPEN_TO_HALF_OPEN(State.FORCED_OPEN, State.HALF_OPEN),
        DISABLED_TO_DISABLED(State.DISABLED, State.DISABLED),
        DISABLED_TO_CLOSED(State.DISABLED, State.CLOSED),
        DISABLED_TO_OPEN(State.DISABLED, State.OPEN),
        DISABLED_TO_FORCED_OPEN(State.DISABLED, State.FORCED_OPEN),
        DISABLED_TO_HALF_OPEN(State.DISABLED, State.HALF_OPEN),
        DISABLED_TO_METRICS_ONLY(State.DISABLED, State.METRICS_ONLY),
        METRICS_ONLY_TO_METRICS_ONLY(State.METRICS_ONLY, State.METRICS_ONLY),
        METRICS_ONLY_TO_CLOSED(State.METRICS_ONLY, State.CLOSED),
        METRICS_ONLY_TO_FORCED_OPEN(State.METRICS_ONLY, State.FORCED_OPEN),
        METRICS_ONLY_TO_DISABLED(State.METRICS_ONLY, State.DISABLED);

        private static final Map<Tuple2<State, State>, StateTransition> STATE_TRANSITION_MAP;
        private final State fromState;
        private final State toState;

        private StateTransition(State fromState, State toState) {
            this.fromState = fromState;
            this.toState = toState;
        }

        public static StateTransition transitionBetween(String name, State fromState, State toState) {
            StateTransition stateTransition = STATE_TRANSITION_MAP.get(Tuple.of(fromState, toState));
            if (stateTransition == null) {
                throw new IllegalStateTransitionException(name, fromState, toState);
            }
            return stateTransition;
        }

        public State getFromState() {
            return this.fromState;
        }

        public State getToState() {
            return this.toState;
        }

        public static boolean isInternalTransition(StateTransition transition) {
            return transition.getToState() == transition.getFromState();
        }

        public String toString() {
            return String.format("State transition from %s to %s", new Object[]{this.fromState, this.toState});
        }

        static {
            STATE_TRANSITION_MAP = Arrays.stream(StateTransition.values()).collect(Collectors.toMap(v -> Tuple.of(v.fromState, v.toState), Function.identity()));
        }
    }

    public static enum State {
        DISABLED(3, false),
        METRICS_ONLY(5, true),
        CLOSED(0, true),
        OPEN(1, true),
        FORCED_OPEN(4, false),
        HALF_OPEN(2, true);

        public final boolean allowPublish;
        private final int order;

        private State(int order, boolean allowPublish) {
            this.order = order;
            this.allowPublish = allowPublish;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

