/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.io.github.resilience4j.circuitbreaker.internal;

import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreaker;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import com.databricks.internal.io.github.resilience4j.core.ConfigurationNotFoundException;
import com.databricks.internal.io.github.resilience4j.core.RegistryStore;
import com.databricks.internal.io.github.resilience4j.core.registry.AbstractRegistry;
import com.databricks.internal.io.github.resilience4j.core.registry.InMemoryRegistryStore;
import com.databricks.internal.io.github.resilience4j.core.registry.RegistryEventConsumer;
import com.databricks.internal.io.vavr.collection.Array;
import com.databricks.internal.io.vavr.collection.HashMap;
import com.databricks.internal.io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class InMemoryCircuitBreakerRegistry
extends AbstractRegistry<CircuitBreaker, CircuitBreakerConfig>
implements CircuitBreakerRegistry {
    public InMemoryCircuitBreakerRegistry() {
        this((com.databricks.internal.io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryCircuitBreakerRegistry(com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        this(CircuitBreakerConfig.ofDefaults(), tags);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs) {
        this(configs, (com.databricks.internal.io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers, com.databricks.internal.io.vavr.collection.Map<String, String> tags, RegistryStore<CircuitBreaker> registryStore) {
        super(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse(HashMap.empty()), Optional.ofNullable(registryStore).orElse(new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig) {
        super(defaultConfig);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, tags);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        super(defaultConfig, registryEventConsumer);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, RegistryEventConsumer<CircuitBreaker> registryEventConsumer, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        super(defaultConfig, registryEventConsumers);
    }

    @Override
    public Seq<CircuitBreaker> getAllCircuitBreakers() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name) {
        return this.circuitBreaker(name, (CircuitBreakerConfig)this.getDefaultConfig());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return this.circuitBreaker(name, (CircuitBreakerConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig config) {
        return this.circuitBreaker(name, config, HashMap.empty());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig config, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> CircuitBreaker.of(name, Objects.requireNonNull(config, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, String configName) {
        return this.circuitBreaker(name, configName, HashMap.empty());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, String configName, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> CircuitBreaker.of(name, (CircuitBreakerConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), this.getAllTags(tags)));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        return this.circuitBreaker(name, circuitBreakerConfigSupplier, HashMap.empty());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> CircuitBreaker.of(name, Objects.requireNonNull((CircuitBreakerConfig)Objects.requireNonNull(circuitBreakerConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }
}

