/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.algorithm;

import com.databricks.internal.jts.algorithm.Orientation;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Quadrant;

public class PolygonNodeTopology {
    public static boolean isCrossing(Coordinate nodePt, Coordinate a0, Coordinate a1, Coordinate b0, Coordinate b1) {
        int compBetween0;
        Coordinate aLo = a0;
        Coordinate aHi = a1;
        if (PolygonNodeTopology.isAngleGreater(nodePt, aLo, aHi)) {
            aLo = a1;
            aHi = a0;
        }
        if ((compBetween0 = PolygonNodeTopology.compareBetween(nodePt, b0, aLo, aHi)) == 0) {
            return false;
        }
        int compBetween1 = PolygonNodeTopology.compareBetween(nodePt, b1, aLo, aHi);
        if (compBetween1 == 0) {
            return false;
        }
        return compBetween0 != compBetween1;
    }

    public static boolean isInteriorSegment(Coordinate nodePt, Coordinate a0, Coordinate a1, Coordinate b) {
        boolean isBetween;
        Coordinate aLo = a0;
        Coordinate aHi = a1;
        boolean isInteriorBetween = true;
        if (PolygonNodeTopology.isAngleGreater(nodePt, aLo, aHi)) {
            aLo = a1;
            aHi = a0;
            isInteriorBetween = false;
        }
        boolean isInterior = (isBetween = PolygonNodeTopology.isBetween(nodePt, b, aLo, aHi)) && isInteriorBetween || !isBetween && !isInteriorBetween;
        return isInterior;
    }

    private static boolean isBetween(Coordinate origin, Coordinate p, Coordinate e0, Coordinate e1) {
        boolean isGreater0 = PolygonNodeTopology.isAngleGreater(origin, p, e0);
        if (!isGreater0) {
            return false;
        }
        boolean isGreater1 = PolygonNodeTopology.isAngleGreater(origin, p, e1);
        return !isGreater1;
    }

    private static int compareBetween(Coordinate origin, Coordinate p, Coordinate e0, Coordinate e1) {
        int comp0 = PolygonNodeTopology.compareAngle(origin, p, e0);
        if (comp0 == 0) {
            return 0;
        }
        int comp1 = PolygonNodeTopology.compareAngle(origin, p, e1);
        if (comp1 == 0) {
            return 0;
        }
        if (comp0 > 0 && comp1 < 0) {
            return 1;
        }
        return -1;
    }

    private static boolean isAngleGreater(Coordinate origin, Coordinate p, Coordinate q) {
        int quadrantQ;
        int quadrantP = PolygonNodeTopology.quadrant(origin, p);
        if (quadrantP > (quadrantQ = PolygonNodeTopology.quadrant(origin, q))) {
            return true;
        }
        if (quadrantP < quadrantQ) {
            return false;
        }
        int orient = Orientation.index(origin, q, p);
        return orient == 1;
    }

    public static int compareAngle(Coordinate origin, Coordinate p, Coordinate q) {
        int quadrantQ;
        int quadrantP = PolygonNodeTopology.quadrant(origin, p);
        if (quadrantP > (quadrantQ = PolygonNodeTopology.quadrant(origin, q))) {
            return 1;
        }
        if (quadrantP < quadrantQ) {
            return -1;
        }
        int orient = Orientation.index(origin, q, p);
        switch (orient) {
            case 1: {
                return 1;
            }
            case -1: {
                return -1;
            }
        }
        return 0;
    }

    private static int quadrant(Coordinate origin, Coordinate p) {
        double dx = p.getX() - origin.getX();
        double dy = p.getY() - origin.getY();
        return Quadrant.quadrant(dx, dy);
    }
}

